PRO read_response,response_lambda,response,d_response, $
                  FilenameInput=filenameinput,xi=xi,yi=yi

; Read response function from a text file
;
; (xi, yi): position of response measurement
; read_response and write_response should work consistently.
; response file format: lambda response

; if ~ defined(calibdir) then set_dir
  
  if ~ keyword_set(filenameinput) then begin
     dir=!IRC_SPECRED_DIR.calibdir+'/RESPONSE/'
     filename=DIALOG_PICKFILE(PATH=dir,filter='*.dat')
     IF (STRLEN(filename) EQ 0) THEN stop
  endif else filename=filenameinput

  filename=filename[0]
  
  response_lambda=FLTARR(2000) & response=FLTARR(2000) & d_response=FLTARR(2000)
  xi=0. & yi=0.
  
  GET_LUN,U & openr,U,filename
  
  readf,u,xi,yi                 ; read position of response measurement
  
  i=0
  WHILE EOF(U) EQ 0 DO BEGIN
     READF, U, x,y,z
     response_lambda[i]=x & response[i]=y & d_response[i]=z
     i=i+1
  ENDWHILE
  
  close,U & FREE_LUN,U
  
  response_lambda=response_lambda[0:i-1] & response=response[0:i-1] & d_response=d_response[0:i-1]
  
  bad_response_region=where(response EQ -1,count)
  if count GT 0 then begin
     response[bad_response_region]=0.
     d_response[bad_response_region]=0.
  endif
  
END
