PRO read_source_table,source_table,ext_source_table=ext_source_table,myfilter=myfilter,dir=dir
  
; Read a source table file
  
  if ~ keyword_set(myfilter) then myfilter='*.tbl'

  if ~ keyword_set(ext_source_table) then $
     filename = DIALOG_PICKFILE(FILTER = myfilter,title='Select External Source Table',path=!IRC_SPECRED_DIR.workdir) $
  else filename=ext_source_table

  if defined(dir) then filename=dir+filename

  readcol,filename,ID,image_x,image_y,image_mask_dx,image_mask_dy,spec_x,spec_y,spec_mask_dx,spec_mask_dy, $
          flux,image_FWHM,spec_bgnoise_ADU,spec_x_pos,spec_x_FWHM,bad_sourcepos_flag, $
          format='I,F,F,I,I,F,F,I,I,F,F,F,F,F,I',skipline=1
; 1st line is header, and ths should be skipped.
  
  n_source=n_elements(image_x)
  if n_source EQ 0 then message,'Error (read_source_table): No data were found in the target table...Stop!'
  
  make_default_source_table,source_table,n_source
  
  source_table.ID=ID
  source_table.image_x=image_x
  source_table.image_y=image_y
  source_table.image_mask_dx=image_mask_dx
  source_table.image_mask_dy=image_mask_dy
  source_table.spec_x=spec_x
  source_table.spec_y=spec_y
  source_table.spec_mask_dx=spec_mask_dx
  source_table.spec_mask_dy=spec_mask_dy
  source_table.flux=flux
  source_table.image_FWHM=image_FWHM
  source_table.spec_bgnoise_ADU=spec_bgnoise_ADU
  source_table.spec_x_pos=spec_x_pos
  source_table.spec_x_FWHM=spec_x_FWHM
  source_table.bad_sourcepos_flag=bad_sourcepos_flag
  
END
