pro rot_image3d,inimage,outimage,header=header

  s=size(inimage) & dim=s[0] & xsize=s[1] & ysize=s[2]
  if dim EQ 3 then num=s[3] else num=1
  s=size(inimage,/type)
  outimage=make_array(ysize,xsize,num,type=s) ;swap x-y axes

  if keyword_set(header) then begin
     extast,header,astr,noparams ; eheck astr information
     if defined(astr) then begin
        header_tmp=header
        sxdelpar,header_tmp,'NAXIS3'
        sxaddpar,header_tmp,'NAXIS',2
        for z=0,num-1 do begin
           hrotate,inimage[*,*,z],header_tmp,rotate_tmp,rotheader,1,errmsg=errmsg
           outimage[*,*,z]=rotate_tmp
        endfor
        sxaddpar,rotheader,'NAXIS3',num,'Number of pixels in Z-axis',after='NAXIS2'
        sxaddpar,rotheader,'NAXIS',3
        header=rotheader
     endif else begin
        for z=0,num-1 do begin
           rotate_tmp=rotate(inimage[*,*,z],1)
           outimage[*,*,z]=rotate_tmp
        endfor
     endelse
  endif else begin
     for z=0,num-1 do begin
        rotate_tmp=rotate(inimage[*,*,z],1)
        outimage[*,*,z]=rotate_tmp
     endfor
     
  endelse
  
end
