pro search_plist,file,var_search_str,value

; file: filename to be searched
; var_search_str: search string, like * or ?
; value: return

; file format
; 1st column: keyword
; 2nd column: value
; 3rd column: type of the value (I for integer, F for float, S for string)

; case insensitive search enforced, with /fold_case option
; for multiple hit, return the first-defined one.
; for zero-fit return '' (null string)

  file1=!IRC_SPECRED_DIR.DATADIR2+file
  
  d = FINDFILE (file1, COUNT = fileExists)
  IF fileExists EQ 0 THEN file1=!IRC_SPECRED_DIR.CALIBDIR+'/PLIST/'+file

  readcol,file1,var_name,value_array,type,format='A,A,A',/silent
  
  matched=where(strmatch(var_name,var_search_str,/FOLD_CASE),count)
  
  if count GT 0 then begin
     value=value_array[matched[0]]
     case type[matched[0]] of
        'I': value=fix(value)
        'F': value=float(value)
        'S': value=string(value)
        else: value=''
     endcase
  endif else value=''
  
end
