pro set_specbox_x_shift,mean_d_offset,for_skysub_only=for_skysub_only,short=short

  common gui,logger

; Set specbox info
  if (!IRC_SPECRED_OBSPARAM.Np_mode EQ 1B || SG2() || LG2() || (SG1() && !IRC_SPECRED_PROCESSOPTION.faint_source_mode)) $
     && keyword_set(for_skysub_only) && !IRC_SPECRED_MISC.first_pass EQ 1B $
     && ~ keyword_set(short) $
  then begin
     case 1 of
        (NP()): begin
           read_specbox_shift_x,mean_d_offset,filename=!IRC_SPECRED_DIR.workdir+'/NP_SPECBOX_SHIFT_X.dat'
           print,'Information (set_specbox_x_shift): read specbox X shift info from NP shift database.'
        end
        (NG()): begin
           read_specbox_shift_x,mean_d_offset,filename=!IRC_SPECRED_DIR.workdir+'/NG_SPECBOX_SHIFT_X.dat'
           print,'Information (set_specbox_x_shift): read specbox X shift info from NG shift database.'
        end
        (SG1() || SG2()): begin
           if !IRC_SPECRED_OBSPARAM.AOT EQ '04A' then begin
              read_specbox_shift_x,mean_d_offset,filename=!IRC_SPECRED_DIR.workdir+'/NP_SPECBOX_SHIFT_X.dat' 
              print,'Information (set_specbox_x_shift): read specbox X shift info from NP shift database.'
           endif else begin
              read_specbox_shift_x,mean_d_offset,filename=!IRC_SPECRED_DIR.workdir+'/NG_SPECBOX_SHIFT_X.dat'
              print,'Information (set_specbox_x_shift): read specbox X shift info from NG shift database.'
           endelse
           mean_d_offset*=!IRC_SPECRED_CHIPINFO.pixscale_nir_x/!IRC_SPECRED_CHIPINFO.pixscale_mirs_x
        end
        (LG2()): begin
           if !IRC_SPECRED_OBSPARAM.AOT EQ '04A' || !IRC_SPECRED_OBSPARAM.AOT EQ '04C' then begin
              read_specbox_shift_x,mean_d_offset,filename=!IRC_SPECRED_DIR.workdir+'/NP_SPECBOX_SHIFT_X.dat'
              print,'Information (set_specbox_x_shift): read specbox X shift info from NP shift database.'
           endif else begin
              read_specbox_shift_x,mean_d_offset,filename=!IRC_SPECRED_DIR.workdir+'/NG_SPECBOX_SHIFT_X.dat'
              print,'Information (set_specbox_x_shift): read specbox X shift info from NG shift database.'
           endelse
           mean_d_offset*=!IRC_SPECRED_CHIPINFO.pixscale_nir_x/!IRC_SPECRED_CHIPINFO.pixscale_mirl_x
        end
     endcase
     !IRC_SPECRED_SPECEXTRACTPARAM.x_offset+=mean_d_offset[0]
     if defined(logger) then logger->append,['     Adopted (from NIR) specbox X offset: '+strim(mean_d_offset[0])+' (pix)']
  endif

end
