function sigma_filter_cube,inimage,width,n_sigma=n_sigma

  if ~ defined(n_sigma) then n_sigma=3

  s=size(inimage) & dim=s[0] & xsize=s[1] & ysize=s[2] & if dim EQ 3 then num=s[3] else num=1
  s=size(inimage,/type)
  outimage=make_array(xsize,ysize,num,type=s)
  
  for z=0,num-1 do begin
     filter_tmp=sigma_filter(inimage[*,*,z],radius=width,/all,/iter,n_sigma=n_sigma)
     outimage[*,*,z]=filter_tmp
  endfor
  
  return,outimage
  
end
