pro tune_sourcepos,image,x,y,x_new,y_new,x_error,y_error, $
                   box_half_size=box_half_size, $
                   median=median,flux=flux,FWHM=FWHM,use_array=use_array,no_photo=no_photo, $
                   mean_dx=mean_dx,mean_dy=mean_dy,silent=silent

  silent=1

  if ~ defined(box_half_size) then begin
;     if !IRC_SPECRED_PROCESSOPTION.ext_source_table_mode then box_half_size=3 $
;     else box_half_size=fix(!IRC_SPECRED_CHIPINFO.APPHOTORAD/2) ;+4+1
;     ; was 4
     box_half_size=3
  endif
  
;  box_half_size=box_half_size
  if LG2() && !IRC_SPECRED_PROCESSOPTION.ext_source_table_mode EQ 1B then begin ;widen the search path 
     box_half_size+=10
  endif
  
  s=size(image) & xsize=s[1] & ysize=s[2]
  x_new=x & y_new=y
  n_source=n_elements(x)
  x_error=fltarr(n_source) & y_error=fltarr(n_source) & FWHM=fltarr(n_source) & flux=fltarr(n_source)
  use_array=intarr(n_source) & weight=fltarr(n_source)

  k=0

  if keyword_set(median) then $
     image_med=sigma_filter(image,radius=1,/all,/iterate) $
  else $
     image_med=image            ;sigma_filter(image,radius=1,/all,/iterate)
  
  xr=round(x) & yr=round(y)
  
  for source_id=0,n_source-1 do begin
     
; check out-of-FOV
     if xr[source_id] GE xsize-1 || xr[source_id] LE 0 || yr[source_id] GE ysize-1 || yr[source_id] LE 0 then begin
        y_new[source_id]=y[source_id]
        x_new[source_id]=x[source_id]
        flux[source_id]=!values.f_nan
;        print,'Warning (tune_sourcepos): '+strim(source_id)+' is out of FOV: '+ $
;              strim(xr[source_id])+' '+strim(yr[source_id])
        continue
     end
     
     box_half_size_x=min([xsize-x[source_id],box_half_size,x[source_id]-0])
     box_half_size_y=min([ysize-y[source_id],box_half_size,y[source_id]-0])
     box_half_size1=round(min([box_half_size_x,box_half_size_y]))

     image_min=image_med[xr[source_id]-box_half_size1>0:xr[source_id]+box_half_size1<(xsize-1), $
                         yr[source_id]-box_half_size1>0:yr[source_id]+box_half_size1<(ysize-1)]
     
     result=mpfit2dpeak_nan(image_min,A, $
                            /tilt,errmsg=errmsg,/positive,chisq=chisq, $
                            estimates=[0,max(image_min), $
                                       !IRC_SPECRED_SOURCEDETECTPARAM.fwhm_for_find+1, $
                                       !IRC_SPECRED_SOURCEDETECTPARAM.fwhm_for_find+1, $
                                       box_half_size1,box_half_size1,0], $
                            dof=dof,perror=perror,bestnorm=bestnorm)

;if source_id EQ 3 then message,'Finish'

;     if ~ defined(A) then begin
;        errmsg+='A is somehow undefined...'
;        A=fltarr(6)
;        perror=fltarr(6)        ; dummy
;        A[4]=-1                 ; to be out of FOV
;      endif

     if defined(perror) then error=PERROR*SQRT(BESTNORM / DOF) else error=[100.,100.,100.,100.,100.,100.]

     if errmsg NE '' then begin
        GCNTRD, image_min, box_half_size1, box_half_size1, xcen, ycen,3
        if xcen EQ -1 then begin
           errmsg+=': GCNTRD also met a fit error.'
;        A=fltarr(6)
           perror=fltarr(6)     ; dummy
           A[4]=-1              ; to be out of FOV
        endif else begin
;        A=fltarr(6)
           A[4]=xcen & A[5]=ycen
           errmsg=''
           perror=fltarr(6)     ; dummy to clear error
;          print,source_id,': GCNTRD measured!'
           error=[1.,1.,1.,1.,1.,1.]
        endelse
     endif
     
     FWHM_TMP=(A[2]+A[3])/2.*2.355

     if A[4] LT 0. || A[4] GT box_half_size1*2.+1. || A[5] LT 0. || A[5] GT box_half_size1*2.+1. $
        || perror[4] GT 1.0 || perror[5] GT 1.0 $
        || errmsg NE '' || FWHM_TMP GT 10. || FWHM_TMP LT 0.3 || $
        finite(error[4],/NAN) || error[4] EQ 0 $
     then begin                 ; bad fit
        x_new[source_id]=x[source_id] & y_new[source_id]=y[source_id]
        FWHM[source_id]=!values.f_nan
                                ; print error reasons
        if ~ keyword_set(silent) then begin
           case 1 of
              (errmsg NE ''): print,'Warning (tune_sourcepos): ',source_id,' :got error message:     '+errmsg
              ((A[4] LT 0 || A[4] GT box_half_size1*2+1) || (A[5] LT 0 || A[5] GT box_half_size1*2+1)): $
                 print,'Warning (tune_sourcepos): '+strim(source_id)+' :source out of search box:     '+ $
                       strim(A[4]-box_half_size1)+' '+strim(A[5]-box_half_size1)
              (perror[4] GT 1.0 || perror[5] GT 1.0): $
                 print,'Warning (tune_sourcepos): '+strim(source_id)+' :offset error too large:'+ $
                       strim(perror[4])+strim(perror[5])
              (FWHM_TMP GT 10.): $
                 print,'Warning (tune_sourcepos): '+strim(source_id)+' :source size too large: '+ $
                       strim((A[2]+A[3])/2.*2.355)+' '+strim(A[2])+' '+strim(A[3])
              (FWHM_TMP LT 0.3): $
                 print,'Warning (tune_sourcepos): '+strim(source_id)+' :source size too small: '+ $
                       strim((A[2]+A[3])/2.*2.355)+' '+strim(A[2])+' '+strim(A[3])
              (finite(error[4],/NAN)): begin
                 print,'Warning (tune_sourcepos): '+strim(source_id)+' :fitting failed.'
              end
              (error[4] EQ 0): begin
                 print,'Warning (tune_sourcepos): '+strim(source_id)+' :fitting failed.'
              end
           endcase
        endif
     endif else begin           ; good fit

        x_offset=A[4]-box_half_size1
        y_offset=A[5]-box_half_size1

        if abs(x_offset) GT 3. || abs(y_offset) GT 3. then begin
;          print,'Warning (tune_source_pos): offset error seems too large!... Assuming zero offset.'
           print,'Warning (tune_source_pos): offset error seems too large!...source_id='+strim(source_id)
           x_offset=0.
           y_offset=0.
           use_array_flag=0
        endif else begin
           use_array_flag=1
        endelse

        x_new[source_id]=xr[source_id]+x_offset
        y_new[source_id]=yr[source_id]+y_offset
        x_error[source_id]=perror[4] & y_error[source_id]=perror[5]
        FWHM[source_id]=FWHM_TMP
        weight[source_id]=1./(error[4])^2.
        if use_array_flag EQ 1 then begin
           use_array[k]=source_id
           k+=1
        endif

     endelse
  endfor

; do ap-photo
  if ~ keyword_set(no_photo) then begin
     irc_darty_photometry,image,x,y,flux,use_array
  endif

  dx=x_new-x & dy=y_new-y
  
  if k EQ 0 then begin
     print,'Warning (tune_source_pos): No data are available for tuning the source positions!'
     use_array=-1
     mean_dx=0 & mean_dy=0 & sigma_dx=0 & sigma_dy=0
  endif else begin
     use_array=use_array[0:k-1]
     
     meanclip_mod,dx[use_array],mean_dx,sigma_dx,weight=weight[use_array],clipsig=3.
     meanclip_mod,dy[use_array],mean_dy,sigma_dy,weight=weight[use_array],clipsig=3.
     
;     print,'Information (tune_source_pos): source mean offset: dx: '+strim(mean_dx[0])+'+-'+strim(sigma_dx[0])+ $
;           '  dy: '+strim(mean_dy[0])+'+-'+strim(sigma_dy[0])
  endelse

end
