FUNCTION weighted_mean, data, weights, $
                            STERR = sterr, EXTERNAL_ERROR = exf, INTERNAL_ERROR = inf, NAN = nan, DATAERR = dataerr

; modified based on w_mean.pro
; being defferent from w_mean, this program returns stddev of input data as STERR.

  ndata = N_ELEMENTS(data)
  IF N_PARAMS() EQ 1 THEN weights = REPLICATE(1.D, ndata)
  
  IF KEYWORD_SET(nan) THEN BEGIN
     find = WHERE(FINITE(data) AND FINITE(weights), nfind)
     IF nfind GT 0 THEN $
        RETURN, weighted_mean(data[find], weights[find], STERR = sterr, EXTERNAL_ERROR = exF, INTERNAL_ERROR = inF) $
     ELSE RETURN, !VALUES.F_NAN
  ENDIF
  
  IF KEYWORD_SET(dataerr) THEN weights2 = 1D / weights^2 ELSE weights2 = weights
  wmean = TOTAL(data * weights2, /DOUBLE) / TOTAL(weights2, /DOUBLE)
; original method:
; var = TOTAL(weights2 * (data - wmean)^2, /DOUBLE) / ( (ndata - 1) * TOTAL(weights2, /DOUBLE) );*ndata

; higher precision method:
  resid=data-wmean
  Var = (total(Resid^2*weights2,/double) - ((total(Resid*weights2,/double))^2)/(ndata*total(weights2,/double))) $
        /((ndata-1.0)*total(weights2,/double)) $
        *ndata
; REMEMBER: I put *ndata in var!

  exf = SQRT(var)
  inf = 1D / SQRT(TOTAL(weights2, /DOUBLE))
  sterr = exf > inf
  
  RETURN, wmean
END
