; 2009/02/11 modified by T.WADA  (supress warning "% CHECK_FITS: ERROR
; - FITS array is not defined" in batch mode)
pro modify_header_for_splot,specheader,wave_array,three_dim=three_dim
  
  fxaddpar,specheader,'W_OFFSET',!IRC_SPECRED_SPECPARAM.wave_offset_pix,'WAVE_OFFSET_PIX (pix)'

  sxdelpar,specheader,'WCSROOT'
  sxdelpar,specheader,'RADECSYS'

  if keyword_set(three_dim) then fxaddpar,specheader,'WCSDIM',3 else fxaddpar,specheader,'WCSDIM',2
  fxaddpar,specheader,'WAT0_001','system=world'
  fxaddpar,specheader,'WAT1_001','wtype=linear'
  fxaddpar,specheader,'WAT2_001','wtype=linear label=Wavelength units=micron'
  fxaddpar,specheader,'DISPAXIS',2,'Dispersion axis in frame'
  
  fxaddpar,specheader,'CTYPE2','LINEAR'
  fxaddpar,specheader,'CRVAL2',wave_array[5] ; was 0
  fxaddpar,specheader,'CDELT2',wave_array[2]-wave_array[1]
  fxaddpar,specheader,'CD2_2' ,wave_array[2]-wave_array[1]
;  if NG() || LG2() then $
;     fxaddpar,specheader,'CRPIX2',1.-!IRC_SPECRED_SPECPARAM.wave_offset_pix $
;  else $
;     fxaddpar,specheader,'CRPIX2',1.+!IRC_SPECRED_SPECPARAM.wave_offset_pix
  fxaddpar,specheader,'CRPIX2',6. ; was 1
 
  fxaddpar,specheader,'CTYPE1','LINEAR'
  fxaddpar,specheader,'CRVAL1',1.
  fxaddpar,specheader,'CDELT1',1.
  fxaddpar,specheader,'CRPIX1',1.
  
  fxaddpar,specheader,'CD1_1' ,1.
  fxaddpar,specheader,'CD1_2' ,0.
  fxaddpar,specheader,'CD2_1' ,0.

  if keyword_set(three_dim) then fxaddpar,specheader,'CD3_3' ,1. ELSE sxdelpar,specheader,'CD3_3'
  
end

pro write_all_output,source_table,space_profile,spec_profile,wave_array,specimage_fc_1d, $
                     refimage_bg,specimage_bg, $
                     refimage_n_bg,refimage_n_bg_short, $
                     specimage_n_sff,specimage_n_sff_short, $
                     specimage_n_wc,specimage_n_wc_short, $
                     specimage_n_fc,specimage_n_fc_short, $
                     res_refimage_bg,res_specimage_bg, $
                     mask_refimage,mask_specimage,mask_specimage_n,$
                     imagheader,specheader,imagheader_extract,specheader_extract, $
                     noisemap,noisemap_n,noisemap_short_n,noise_mask, $
                     dir=dir,image_4d=image_4d,savefile=savefile,write_indiv_spec=write_indiv_spec
  common gui,logger

  get_prefix,dir,prefix

; output log
  if defined(logger) then begin
     log=logger->gettext()
     writecol,prefix+'.log',log,fmt='A'
  endif

; tweaking headers
  imagheader=imagheader[*,0]
  specheader=specheader[*,0]
  
  imagheader_whole=imagheader & sxdelpar,imagheader_whole,'NAXIS3'
  specheader_whole=specheader & sxdelpar,specheader_whole,'NAXIS3'

; check headers
  check_fits,refimage_bg,imagheader_whole,/update,/silent
  check_fits,specimage_bg,specheader_whole,/update,/silent
  
; 2009/02/11 T.WADA
;;  check_fits,refimage_n_bg,imagheader,/update,/silent
;;  check_fits,specimage_n_wc,specheader,/update,/silent

;;; Write FITS images

  if defined(image_4d) then begin
     s=size(image_4d) & n_subframe=s[4]
     for subframe_id=0,n_subframe-1 do begin
        mwrfits,image_4d[*,*,*,subframe_id], $
                prefix+ '.specimage_wc_indiv_frame'+strim(subframe_id)+'.fits',specheader,/create
     endfor
  endif

; commented out because one does not need to have _frame_?.fits data.
;  if keyword_set(write_indiv_spec) && ~ NP() then begin
;     s=size(specimage_n_wc) & if s[0] EQ 2 then n_subframe=1 else n_subframe=s[3]
;     specheader_tmp=specheader
;     for subframe_id=0,n_subframe-1 do begin
;        modify_header_for_splot,specheader_tmp,wave_array
;        mwrfits,specimage_n_wc[*,*,subframe_id], $
;                prefix+ '.specimage_wc_indiv_frame_'+strim(subframe_id)+'.fits',specheader_tmp,/create
;        mwrfits,specimage_n_fc[*,*,subframe_id], $
;                prefix+ '.specimage_fc_indiv_frame_'+strim(subframe_id)+'.fits',specheader_tmp,/create
;     endfor
;  endif


; whole image products
  mwrfits,refimage_bg,prefix+ '.refimage_bg.fits',imagheader_whole,/create
  mwrfits,specimage_bg,prefix+'.specimage_bg.fits',specheader_whole,/create

  if !IRC_SPECRED_PROCESSOPTION.AUTO_IMAGE_STACK EQ 1B then return

; 2009/02/11 T.WADA
  check_fits,specimage_n_wc,specheader,/update,/silent
  check_fits,refimage_n_bg,imagheader,/update,/silent

  mwrfits,res_refimage_bg,prefix+ '.residual_refimage_bg.fits',imagheader_whole,/create
  mwrfits,res_specimage_bg,prefix+'.residual_specimage_bg.fits',imagheader_whole,/create

  mwrfits,mask_refimage,prefix+ '.refimage_mask.fits',imagheader_whole,/create
  mwrfits,mask_specimage,prefix+'.specimage_mask.fits',specheader_whole,/create

  mwrfits,noisemap,prefix+'.specimage_noisemap.fits',specheader_whole,/create
  mwrfits,noise_mask,prefix+'.specimage_noisemask.fits',specheader_whole,/create

; extracted image products
  mwrfits,refimage_n_bg,prefix+    '.refimage_bg_indiv.fits',imagheader,/create

; spec WCS for 3D fits
  specheader_tmp=specheader
  modify_header_for_splot,specheader_tmp,wave_array,/three_dim
  mwrfits,specimage_n_wc,prefix+'.specimage_wc_indiv.fits',specheader_tmp,/create
  mwrfits,specimage_n_fc,prefix+'.specimage_fc_indiv.fits',specheader_tmp,/create
  
  mwrfits,mask_specimage_n,prefix+    '.specimage_mask_indiv.fits',specheader,/create

  mwrfits,noisemap_n,prefix+    '.specimage_noisemap_indiv.fits',specheader,/create

;  write (and read) ascii spectra
;  write_spec,wave_array,specimage_fc_1d
;  read_spec,wave_array,specimage_fc_1d

; Write a catalog file
  write_target_table,source_table,prefix=prefix;,dir=dir
  write_source_table,source_table,prefix=prefix;,dir=dir

;  write_profile,space_profile,dir=dir,filename=prefix+'.space1Dprof.dat'
;  write_profile,spec_profile,dir=dir,filename=prefix +'.spec1Dprof.dat'

;  mwrfits,badpixelimage_image,strcompress(prefix+'.badpiximage.fits',/remove_all)
;  mwrfits,badpixelimage_spec,strcompress(prefix+'.badpixspecimage.fits',/remove_all)

; region files
  regionfilename=prefix+'.refimage.reg'
  write_ds9_region_file,source_table,filename=regionfilename,/IMAG
  regionfilename=prefix+'.specimage.reg'
  write_ds9_region_file,source_table,filename=regionfilename

; putwcs
  if !IRC_SPECRED_PROCESSOPTION.putwcs_mode EQ 1B && ~ LG2() then put_wcs,refimage_bg,imagheader_whole,prefix

; create IDL save file
  savefile=prefix+'.IRC_SPECRED_OUT.sav'
  save,source_table,source_id,wave_array, $
       refimage_bg,specimage_bg, $
       refimage_n_bg,refimage_n_bg_short, $
       specimage_n_sff,specimage_n_sff_short, $
       specimage_n_wc,specimage_n_wc_short, $
       res_refimage_bg,res_specimage_bg, $
       mask_refimage,mask_specimage,mask_specimage_n, $
       imagheader,specheader,imagheader_extract,specheader_extract, $
       noisemap,noisemap_n,noisemap_short_n,noise_mask, $
       /system,/comm,/variable,filename=savefile;,/ver

end
