PRO write_ds9_region_file,source_table,filename=filename,IMAG=IMAG,space_shift=space_shift,nsum=nsum

;  common measured_offsets,space_shift,nsum
  
  if ~ defined(space_shift) then space_shift=0
  if ~ defined(nsum) then nsum=3

  if ~ keyword_set(filename) then filename=DIALOG_PICKFILE(FILTER='*.reg',title='DS9 Region File Name',path=!IRC_SPECRED_DIR.datadir)
  GET_LUN,U & openw,U,filename

  n_source=n_elements(source_table)

  if keyword_set(IMAG) then begin ; for IMAG
     for source_id=0,n_source-1 do begin
        if finite(source_table[source_id].image_x) && finite(source_table[source_id].image_y) then begin
           box_pos_x=source_table[source_id].image_x+1.
           box_pos_y=source_table[source_id].image_y+1.
           if finite(source_table[source_id].image_FWHM) then $
              radius=(source_table[source_id].image_FWHM/2. > 1.) $
           else $
              radius=0.5
           if source_table[source_id].bad_sourcepos_flag EQ 1B then $
              printf,U,box_pos_x,box_pos_y,radius,source_id,$
                     format='("image;circle(",F8.3,",",F8.3,",",F8.3,") # color=red text={",I3,"}")' $
           else $
              printf,U,box_pos_x,box_pos_y,radius,source_id,$
                     format='("image;circle(",F8.3,",",F8.3,",",F8.3,") # text={",I3,"}")'
        endif
     endfor
     close,U & FREE_LUN,U
     return

  endif else begin              ; for SPEC

     for source_id=0,n_source-1 do begin
        if finite(source_table[source_id].spec_x) && finite(source_table[source_id].spec_y) then begin
           if defined(nsum) EQ 0 then nsum=source_table[source_id].spec_1Dextract_dx
           box_pos_x=source_table[source_id].spec_x+1.
           box_pos_y=source_table[source_id].spec_y+1.
           if finite(!IRC_SPECRED_SPECPARAM.wave_offset_pix) then begin ; was defined
              if LG2() then $
                 box_pos_y-=!IRC_SPECRED_SPECPARAM.wave_offset_pix $
              else $
                 box_pos_y-=!IRC_SPECRED_SPECPARAM.wave_offset_pix ; was plus for LG2
           endif
           
; specimage extraction area (object + surrounding sky)
           printf,U,box_pos_x,box_pos_y,source_table[source_id].spec_mask_dx,source_table[source_id].spec_mask_dy,0,source_id,$
                  format='("image;box(",F8.3,",",F8.3,",",F8.3,",",F8.3,",",I5,") # text={",I3,"}")'
           
; object area
           printf,U,box_pos_x,box_pos_y,!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx,!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy,0,$
                  format='("image;box(",F8.3,",",F8.3,",",F8.3,",",F8.3,",",I5,") # color=blue background")'
          
; spec1d extraction area (peak of objects)
           if source_table[source_id].spec_x_pos NE 0 then begin
              spec_pos_x=box_pos_x-(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx-1)/2+source_table[source_id].spec_x_pos
              hight=source_table[source_id].spec_mask_dy
              if nsum EQ 0 || (~ defined(nsum)) then nsum=3
              printf,U,spec_pos_x+space_shift,box_pos_y,nsum,hight,0,$
                     format='("image;box(",F8.3,",",F8.3,",",F8.3,",",F8.3,",",I5,") # color=red")'
           endif
        endif
        
     endfor
     
; for Zero'th order light
     if NP() then begin         ; if NP, stop here and return...
        close,U & FREE_LUN,U
        return
     endif
     
     for source_id=0,n_source-1 do begin
        if finite(source_table[source_id].spec_x) && finite(source_table[source_id].spec_y) then begin
           zero_pos_x=source_table[source_id].spec_x+1.+!IRC_SPECRED_SPECEXTRACTPARAM.x_zero_offset+space_shift
           zero_pos_y=source_table[source_id].spec_y+1.+!IRC_SPECRED_SPECEXTRACTPARAM.y_zero_offset
           if finite(!IRC_SPECRED_SPECPARAM.wave_offset_pix) then begin
              if LG2() then $
                 zero_pos_y-=!IRC_SPECRED_SPECPARAM.wave_offset_pix $
              else $
                 zero_pos_y-=!IRC_SPECRED_SPECPARAM.wave_offset_pix ; was plus for LG2
           endif
           radius=(source_table[source_id].image_FWHM/2.) > 1.
           printf,U,zero_pos_x,zero_pos_y,radius,source_id,$
                  format='("image;circle(",F8.3,",",F8.3,",",F8.3,") # color=yellow text={",I5,"}")'
;          print,zero_pos_x,zero_pos_y,radius,source_id,$
;                 format='("image;circle(",F8.3,",",F8.3,",",F8.3,") # color=yellow text={",I5,"}")'
        endif
     endfor
     close,U & FREE_LUN,U
  endelse
  
END
