PRO write_ircdistdata,source_table,a0,a1,a2,use_array

; Write distortion measurement results
; Called after irc_spectrace
; So far no read routine is created as of Oct 24.

; common dir_structure,datadir,calibdir
  
  DIR=!IRC_SPECRED_DIR.calibdir+'/DISTPAR/'
  filename=DIALOG_PICKFILE(path=DIR,filter='*.dat')
  IF (STRLEN(filename) EQ 0) THEN message,'Error (write_ircdistdata): No filename was set...Stop!'
  
  n_data=n_elements(a0)
  
  if n_elements(use_array) EQ 0 then begin ; if use_array is not supplied, use all the data
     use_array=intarr(n_data)
     use_array[*]=1
     use_array2=indgen(n_data)
  endif else begin
     use_array2=where(use_array EQ 1, count)
     if count EQ 0 then message,'Error (write_ircdistdata): No valid data in use_array...Stop!'
  endelse
  
  GET_LUN,U & openw,U,filename,/append
  
  n_data_use=n_elements(use_array2)
  
  
  for i=0,n_data_use-1 do printf,U, $
                                 source_table[use_array2[i]].image_x, $
                                 source_table[use_array2[i]].image_y, $
                                 a0[i],a1[i],a2[i]
  
  close,U & FREE_LUN,U
  
END
