PRO write_spec,lambda,flux,d_flux_n,d_flux_p, $
               watt=watt,mjy=mjy,lambda2=lambda2,filename=filename,no_wl_limit=no_wl_limit,redshift=redshift,diffuse=diffuse,space_shift=space_shift,nsum=nsum

; Write spectrum on an ascii file

;  common measured_offsets,space_shift,nsum
  if ~ defined(nsum) then nsum=3
  if ~ defined(space_shift) then space_shift=0

  s=size(flux)
  if ~ defined(d_flux_n) then d_flux_n=fltarr(s[1]) ; dummy array
  if~  defined(d_flux_p) then d_flux_p=fltarr(s[1]) ; dummy array

  if ~ defined(redshift) then redshift=0.

  if ~ defined(filename) then $
     outfilename = DIALOG_PICKFILE (FILTER = '*.spc',title='Spectrum File Name',path=!IRC_SPECRED_DIR.calibdir) $
  else outfilename=filename

  case 1 of
     (keyword_set(watt)): begin
        flux_plot=jansky_to_w_cm2_um(lambda,flux)
        d_flux_n_plot=jansky_to_w_cm2_um(lambda,flux_n)
        d_flux_p_plot=jansky_to_w_cm2_um(lambda,flux_p)
     end
     (keyword_set(mjy)): begin
        flux_plot=flux*1000.
        d_flux_n_plot=d_flux_n*1000.
        d_flux_p_plot=d_flux_p*1000.
     end
     (keyword_set(diffuse)): begin
        arcsec2=nsum*!IRC_SPECRED_CHIPINFO.pixscale_x*5.;!IRC_SPECRED_CHIPINFO.slit_width
        flux_plot=jansky_to_megajansky_per_str(flux,arcsec2)
        d_flux_n_plot=jansky_to_megajansky_per_str(d_flux_n,arcsec2)
        d_flux_p_plot=jansky_to_megajansky_per_str(d_flux_p,arcsec2)
     end
     else: begin
        flux_plot=flux
        d_flux_n_plot=d_flux_n
        d_flux_p_plot=d_flux_p
     end
  endcase

  if s[0] EQ 1 then begin       ; single source
     GET_LUN,U & openw,U,outfilename
     for i=0,n_elements(lambda)-1 do begin
        if keyword_set(no_wl_limit) || $
           (lambda[i] GT !IRC_SPECRED_SPECPARAM.w_cover_2[0] && lambda[i] LT !IRC_SPECRED_SPECPARAM.w_cover_2[1]) then $
              printf,U,lambda[i]/(1.+redshift),flux_plot[i],d_flux_n_plot[i],d_flux_p_plot[i]
     endfor
     close,U & FREE_LUN,U
     
  endif else begin              ; multiple sources
     
     for source_id=0,s[2]-1 do begin
        outfilename=!IRC_SPECRED_DIR.tmpdir+'/tmp_'+string(source_id)+'.spc'
        GET_LUN,U & openw,U,outfilename
        for i=0,n_elements(lambda)-1 do begin
           if  keyword_set(no_wl_limit) || $
              (lambda[i] GT !IRC_SPECRED_SPECPARAM.w_cover_2[0] && lambda[i] LT !IRC_SPECRED_SPECPARAM.w_cover_2[1]) then $
                 printf,U,lambda[i]/(1.+redshift),flux_plot[i,source_id],d_flux_n_plot[i_source_id],d_flux_p_plot[i_source_id]
        endfor
        close,U & FREE_LUN,U
     endfor
     
  endelse
  
END
