PRO write_spec1d_wc,wave_array,spec1d_wc,source_id

; Write response to a text file
; (x,y): position of response measurement
; This is for fitting spatial variation of response.
; read_response and write_response should work consistently.

;common dir_structure,datadir,calibdir

if ~ defined(source_id) then source_id=0

dataoutdir=!IRC_SPECRED_DIR.calibdir+'/RESPONSE'

outfilename = DIALOG_PICKFILE (FILTER = 'SPEC1D*.dat',title='spec1d_wc Table Output File Name',path=dataoutdir)

inf_region=where(finite(wave_array,/infinity),count)
if count GT 0 then wave_array[inf_region]=-1.
nan_region=where(finite(wave_array,/NAN),count)
if count GT 0 then wave_array[nan_region]=-1.

inf_region=where(finite(spec1d_wc,/infinity),count)
if count GT 0 then spec1d_wc[inf_region]=-1.
nan_region=where(finite(spec1d_wc,/NAN),count)
if count GT 0 then spec1d_wc[nan_region]=-1.

GET_LUN,U & openw,U,outfilename

for i=0,n_elements(spec1d_wc[*,source_id])-1 do printf,U,wave_array[i],spec1d_wc[i,source_id]

close,U & FREE_LUN,U

END
