PRO write_target_table,source_table,x,y, $
                       dir=dir,prefix=prefix,nir_flag=nir_flag,no_nir_rotation=no_nir_rotation,filename=filename

; filename = DIALOG_PICKFILE (FILTER = '*.tbl',title='Target Table Output File Name',path=dir)
  if ~ defined(filename) then begin
     if ~ defined(prefix) then get_prefix,dir,prefix
     if defined(dir) then prefix=dir+prefix
     filename=prefix+'.target_table.tbl'
  endif else $
     filename=dir+'/'+filename
  
  if defined(source_table) then n_source=n_elements(source_table) else n_source=n_elements(x)

  if defined(source_table) then begin
     x_tmp=source_table.image_x
     y_tmp=source_table.image_y
     nir_flag=nir()
  endif else begin
     x_tmp=x
     y_tmp=y
  endelse

  if NIR() && defined(nir_flag) && (~ defined(no_nir_rotation)) then begin
     tmp=y_tmp
     y_tmp=511-x_tmp
     x_tmp=tmp
  endif

  GET_LUN,U & openw,U,filename

  for source_id=0,n_source-1 do begin
     printf,U,x_tmp[source_id]+1.0,y_tmp[source_id]+1.0 ; +1.0 for FITS viewer coordinates
  endfor
  
  close,U & FREE_LUN,U
  
END
