# irc.cl -- the master file of IRC imaging data reduction package
# Created: Yoshifusa Ita, 02-Jul-05
# 11-Jul-05 - Add pipeline (Y. Ita)


# Load some of the IRAF package so the user can access them without loading.
dataio
images
language
lists
digiphot
apphot
obsolete
plot
proto
softools
system
utilities
noao
imred
ccdred
artdata
crutil
ccdtest


# This package requires FITS image type
reset imtype = "fits"

# The header of those images contains a humongous number of 
# keywords, which do not fit into the space allocated by IRAF 
# (each card is 160 bytes). 
# The solution is to enlarge this space by modifying the 
# corresponding variable, ie reset min_lenuserarea=600000 
# (or any other appropriate size).
# reference:
# http://www.iac.es/galeria/ncaon/IRAFSoporte/Iraf-FAQ.html
reset min_lenuserarea = 256000

# set environment
cl < "irc$/lib/setenv.dat"

# set path
cl < "irc$/lib/setpath.dat"

package irc, bin = ircbin$

task 	redbox.pkg 	= "redbox$redbox.cl"
task 	greenbox.pkg 	= "greenbox$greenbox.cl"
task 	bluebox.pkg 	= "bluebox$bluebox.cl"
task 	irc_tool.pkg    = "irc_tool$irc_tool.cl"
task 	prepipeline 	= "irchome$prepipeline.cl"
task 	pipeline        = "irchome$pipeline.cl"
task 	$unlearn_all    = "irchome$unlearn_all.cl"
#task 	postpipeline 	= "irchome$postpipeline.cl"

#Load packages
cl < irc$load.cl

# Print the Welcome banner
type irchome$welcome.txt

clbye()
