#!/usr/local/bin/perl
# checkirclog.pl -- To check if the irclog is correct
# Created: Yoshifusa Ita, 14-Jul-05

# File Open
open(IN, "irclog") || die "$!"; 

@dame=();
$wrong = 0;
while (<IN>){
    chomp;
    @buf = split(/\s+/, $_);
    if($buf[0] !~ /\#/){ # $B%3%a%s%H9T$G$J$+$C$?$i(B
	$n_col = @buf;
	if($n_col!=10){
	    push(@dame, $_);
	    $wrong += 1;
	}
    }
}
close(IN);

if($wrong > 0){
    print("\t !!! WARNING !!!\n");
    print("\n");
    print("Some keywords seem to be absent in the fits header.\n");
    print("\n");
    print("Before running the pipeline, check the raw fits files in ../rawdata\n");
    print("if all of them definitely contain the following keywords in their header.\n");
    print("\t FRAME OBJECT NAXIS1 FILTER RA-SET DEC-SET AOT EXPID IDNUM SUBID\n");
    print("If not, remove or comment out the keyword-deficient files from the irclog.\n");
    print("After that, you can run the pipeline.\n");
    print("\n");
    print("Though may not be necessary... this is an advice.\n");
    print("Remove or comment-out the following lines in the irclog, and you may be happy.\n");
    for($i=0;$i<$wrong;$i+=1){
	printf("%s\n",$dame[$i]);
    }
}

















