#!/bin/sh
PHOT=/irafaddin/irc/perl/check_photometry.pl
STDEV=/irafaddin/irc/perl/stdev-sh
MEDIAN=/irafaddin/irc/perl/median-sh
MEAN=/irafaddin/irc/perl/mean-sh

${PHOT} ${1} ${2} | sort -n -k 3 | awk '{if($1<16.0){print $3}}' > hage.dat
stdev=`${STDEV} -p 0.3 hage.dat` 
median=`${MEDIAN} hage.dat` 
mean=`${MEAN} hage.dat` 
ndata=`wc -l hage.dat | awk '{print $1}'`
#echo $ndata $mean $median $stdev

sigma=2.0

for i in `seq 1 20`
do
  awk '{ if( ($1 > mean-sigma*stdev)&&($1 < mean+sigma*stdev) ){print $1} }' mean=$mean sigma=$sigma stdev=$stdev hage.dat > clipped
  stdev=`${STDEV} -p 0.3 clipped` 
  median=`${MEDIAN} clipped` 
  mean=`${MEAN} clipped`
  ndata=`wc -l clipped | awk '{print $1}'`
#  echo $ndata $mean $median $stdev
  \mv clipped hage.dat
done

\rm -rf hage.dat 

err=$(echo "$stdev/sqrt($ndata)" | bc -l)
err=`printf "%9.6f\n" $err`

echo "Nstar=" $ndata "<dMag>=" $mean "<dMag>_err=" $err

echo $mean $err > "mag_diff.dat"
