#!/usr/local/bin/perl
# selectPSF.pl 
# Created: Yoshifusa Ita, 06-Aug-28

if(@ARGV < 5){
    die "Usage: selectPSF.pl *.pst.0 2000 10\n";
}

$fname = $ARGV[0];
open(IN, $fname) || die "$ARGV[0] : $!";
$skyval = $ARGV[1];
chomp $skyval;
$skysig = $ARGV[2];
chomp $skysig;
$blimit = $ARGV[3];
chomp $blimit;
$flimit = $ARGV[4];
chomp $flimit;

$sigma=2.0;
$radius=7.0;

$fname2 = (split(/\./,$fname))[0];
$fname2 .= ".fits.coo.0";

while(<IN>){
    $data1 = $_;
    chomp($data1);
    if($data1 !~ /^\#/){
	($x1, $y1, $mag, $sky) = (split(/\s+/,$data1))[1,2,3,4];
	open(IN2, $fname2);
	$proximity = 0;
	while(<IN2>){
	    $data2 = $_;
	    chomp($data2);
	    if($data2 !~ /^\#/){
		($x2, $y2) = (split(/\s+/,$data2))[1,2];
		$dx = ($x2 - $x1)*($x2 - $x1);
		$dy = ($y2 - $y1)*($y2 - $y1);
		$dr = sqrt($dx + $dy);
		if($dr < $radius){
		    $proximity += 1;
		}
	    }
	}
	close(IN2);
	
	if($x1 > 20 && $proximity < 2 && $mag > $blimit && $mag < $flimit && $sky > 0.0 && $sky > $skyval - $sigma*$skysig && $sky < $skyval + $sigma*$skysig){
	    print($data1,"\n");
	}

    }else{
	print($data1,"\n");
    }
}

close(IN);
