# pipeline.cl -- IRC imaging data reduction pipeline master file
# Created: Yoshifusa Ita, 15-Jul-05
# 08-Jun-05 - Add greenbox.anomalous_pix (Y. Ita)
# 07-Jul-05 - Add greenbox.linearity (Y. Ita)
# 29-Aug-05 - Add greenbox.distortion (Y. Ita)
# 14-Sep-05 - Add greenbox.saturation (Y. Ita)
# 15-Sep-05 - Add greenbox.flat (Y. Ita)
# 16-Sep-05 - Add greenbox.dark (Y. Ita)
# 14-Oct-05 - Add bluebox.coadd (Y. Ita)
# Updated: Yoshifusa Ita, 18-Aug-06  add interactive mode
# Updated: Yoshifusa Ita, 30-Aug-06  add self-dark subtraction mode
# Updated: Takehiko Wada 2007/02/03  add coadd option. The default is "yes".
# Updated: Yoshifusa Ita  11-Apr-07  add greenbox.aspectratio 
# Updated: Yoshifusa Ita  13-Jun-07  add defaultflat option

procedure pipeline

string  ircconst 	 {"constants.database", prompt="IRC constants database file name"}
string 	com_mode 	 {"median", prompt="combine mode: average/median"}
int	com_area 	 {2,min=1,max=2, prompt="stack area: 1:common area 2:whole area"}
int	sky_area 	 {2,min=1,max=2, prompt="sky matching area: 1:common area 2:whole area"}
real    det_sig          {3.,min=1.,max=1000., prompt="Threshold in sigma for source detection"}
real    sig_rej          {3.,min=0.,max=100., prompt="Rejection unit in sigmas"}
int     max_itr          {10,min=1,max=10, prompt="Maximum number of iterations"}
string 	obslog 		 {"irclog", prompt="output of the mkirclog"}
bool 	cosmicray = yes  {prompt="Detect and replace cosmic rays in MIRS images?"}
bool 	wcs = no         {prompt="Try to compute wcs and write it in the header?"}
bool 	selfdark = no    {prompt="Use selfdark instead of Super-Dark?"}
bool 	coaddshort = no  {prompt="Coadd short exposure frames?"}
bool 	interactive = no {prompt="Run pipeline interactively?"}
bool 	deltemp = yes    {prompt="Delete intermediate files?"}
string  rejection        {"sigclip", prompt="rej in coadd:minmax|ccdclip|crreject|sigclip|avsigclip|pclip|none"}
bool    rej_sky = yes    {prompt="Remove image(s) with outlier sky level?"}
bool    skip_L = no      {prompt="Skip coadding MIRL images?"}
bool    submedsky = no   {prompt="Subtract median filtered sky in adjust_sky?"}
bool 	coadd   = yes    {prompt="Coadd?"}
bool    defaultflat = yes {prompt="Use pipeline's default flat?"}
bool 	verbose = no     {prompt="Print verbose progress messages?\n"}

string  mode="al"
struct 	*list0

begin
 string irc_const
 string commode
 int comarea
 int skyarea
 real detsig
 real sigrej
 int maxitr
 string logfile
 bool self_dark, coadd_short, ia, verb, deltmp, setwcs, rejsky, skipl, sub_medsky, coadd_frames, cosmic
 string ans
 string rejtype
 bool def_flat
 string prefix

 print ("\n")
 print ("### PIPELINE ###\n")
 print ("IRC imaging data reduction pipeline start...\n")

# Get query parameter
 irc_const = ircconst
 commode = com_mode
 comarea = com_area
 skyarea = sky_area
 detsig = det_sig
 sigrej = sig_rej
 maxitr = max_itr
 logfile = obslog
 setwcs = wcs
 self_dark = selfdark
 coadd_short = coaddshort
 ia = interactive
 deltmp = deltemp
 rejtype = rejection
 verb = verbose
 rejsky = rej_sky
 sub_medsky = submedsky
 skipl = skip_L
 coadd_frames=coadd
 cosmic = cosmicray
 def_flat = defaultflat


# make sure that prepipeline has been processed.
 if( !access(logfile) ){
	print ("You should run prepipeline first.")
	bye
 }


# if interactive = yes
 if (ia) print("Pipeline runs in INTERACTIVE mode\n")


# Mask bad/hot pixels
# add prefix of "a"
# bad/hot pixels -> 0
 if(ia){
	print("\n \nMask bad/hot pixels.\n")
	print("Proceed ? -> y/e (Yes/End), default=y:\n")
	ans = "y" ; scan(ans)
        if(ans=="e"||ans=="E"){
		bye
	}
 }
 anomalous_pix(irc_const, logfile, "", verb) ; prefix = "a"


# Correct wraparound pixels
# add prefix of "w"
 if(ia){
	print("\n \nCorrect wraparound pixels.\n")
	print("Proceed ? -> y/s/e (Yes/Skip/End), default=y:\n")
	ans = "y" ; scan(ans)
        if(ans=="e"||ans=="E"){
		bye
        }else if(ans=="s"||ans=="S"){
		print("WRAPAROUND is skipped.\n") ; prefix = ""//prefix ; goto next03
	}
 }
 wraparound(irc_const, logfile, prefix, deltmp, verb) ; prefix = "w"//prefix


next03:
# Dark subtraction
# add prefix of "D"
 if(ia){
	print("\n \nDark subtraction.\n")
	print("Proceed ? -> y/s/e (Yes/Skip/End), default=y:\n")
	ans = "y" ; scan(ans)
        if(ans=="e"||ans=="E"){
		bye
        }else if(ans=="s"||ans=="S"){
		print("DARK SUBTRACTION is skipped.\n") ; prefix = ""//prefix ; goto next04
	}
 }
 dark(irc_const, logfile, prefix, self_dark, deltmp, verb) ; prefix = "D"//prefix


next04:
# Fowler sampling/bit shift renormalization
# add prefix of "n"
 if(ia){
	print("\n \nFowler sampling/bit shift renormalization.\n")
	print("Proceed ? -> y/e (Yes/End), default=y:\n")
	ans = "y" ; scan(ans)
        if(ans=="e"||ans=="E"){
		bye
        } # ircnorm must be done and cannot be skipped.
 }
 ircnorm(irc_const, logfile, prefix, deltmp, verb) ; prefix = "n"//prefix


# Subtract scattered light pattern
# add prefix of "c"
 if(ia){
	print("\n \nSubtract scattering light pattern.\n")
	print("Proceed ? -> y/s/e (Yes/Skip/End), default=y:\n")
	ans = "y" ; scan(ans)
        if(ans=="e"||ans=="E"){
		bye
        }else if(ans=="s"||ans=="S"){
		print("SCATTERING LIGHT PATTERN SUBTRACTION is skipped.\n") ; prefix = ""//prefix ; goto next05
	}
 }
 scatt_light(irc_const, logfile, prefix, deltmp, verb) ; prefix = "c"//prefix


next05:
# Cosmic ray rejection
# add prefix of "C"
 if(ia){
	print("\n \nDetect and replace cosmic rays in MIRS images.\n")
	print("Proceed ? -> y/s/e (Yes/Skip/End), default=y:\n")
	ans = "y" ; scan(ans)
        if(ans=="e"||ans=="E"){
		bye
        }else if(ans=="s"||ans=="S"){
		print("COSMICRAY is skipped.\n") ; prefix = ""//prefix ; goto next06
	}else{
		cosmic = yes
	}
 }
 if(cosmic){
	 cosmic_ray(irc_const, logfile, prefix, deltmp, verb) ; prefix = "C"//prefix
 }


next06:
# Linearize 
# add prefix of "l"
# 0 value pixels -> 0
 if(ia){
	print("\n \nLinearity correction.\n")
	print("Proceed ? -> y/s/e (Yes/Skip/End), default=y:\n")
	ans = "y" ; scan(ans)
        if(ans=="e"||ans=="E"){
		bye
        }else if(ans=="s"||ans=="S"){
		print("Linearity correction is skipped.\n") ; prefix = ""//prefix ; goto next07
	}
 }
 linearity(irc_const, logfile, prefix, deltmp, verb) ; prefix = "l"//prefix


next07:
# Mask saturated pixels
# add prefix of "s"
# saturated pixels -> 0
 if(ia){
	print("\n \nMask saturated pixels.\n")
	print("Proceed ? -> y/s/e (Yes/Skip/End), default=y:\n")
	ans = "y" ; scan(ans)
        if(ans=="e"||ans=="E"){
		bye
        }else if(ans=="s"||ans=="S"){
		print("SATURATED PIXEX MASKING is skipped.\n") ; prefix = ""//prefix ; goto next08
	}
 }
 saturation(irc_const, logfile, prefix, deltmp, verb) ; prefix = "s"//prefix


next08:
# Imaging area mask 
# add prefix of "m"
# add imaging area = 0, slit area = -99999
 if(ia){
	print("\n \nMask slit area.\n")
	print("Proceed ? -> y/s/e (Yes/Skip/End), default=y:\n")
	ans = "y" ; scan(ans)
        if(ans=="e"||ans=="E"){
		bye
        }else if(ans=="s"||ans=="S"){
		print("SLIT AREA MASKING is skipped.\n") ; prefix = ""//prefix ; goto next09
	}
 }
 slit_mask(irc_const, logfile, prefix, deltmp, verb) ; prefix = "m"//prefix


next09:
# Flat fielding 
# add prefix of "f"
 if(ia){
	print("\n \nFlat fielding.\n")
	print("Proceed ? -> y/s/e (Yes/Skip/End), default=y:\n")
	ans = "y" ; scan(ans)
        if(ans=="e"||ans=="E"){
		bye
        }else if(ans=="s"||ans=="S"){
		print("Flat fielding is skipped.\n") ; prefix = ""//prefix ; goto next10
	}
 }
 flat(irc_const, logfile, prefix, def_flat, deltmp, verb) ; prefix = "f"//prefix


next10:
# Aspect ratio resampling
# add prefix of "e"
# resampled to 1:1
 if(ia){
	print("\n \nResample aspect ratio.\n")
	print("Proceed ? -> y/e (Yes/End), default=y:\n")
	ans = "y" ; scan(ans)
        if(ans=="e"||ans=="E"){
		bye
        }
 }
 aspect_ratio(irc_const, logfile, prefix, deltmp, verb) ; prefix = "e"//prefix


# Distortion correction 
# add prefix of "d"
# if(ia){
#	print("\n \nDistortion correction.\n")
#	print("Proceed ? -> y/e (Yes/End), default=y:\n")
#	ans = "y" ; scan(ans)
#        if(ans=="e"||ans=="E"){
#		bye
#	} # must be done
# }
# distortion(irc_const, logfile, prefix, deltmp, verb) ; prefix = "d"//prefix


# Coadd
 if(ia){
	print("\n \nStack images and put wcs.\n")
	print("Proceed ? -> y/s/e (Yes/Skip/End), default=y:\n")
	ans = "y" ; scan(ans)
        if(ans=="e"||ans=="E"){
		goto finish
        }else if(ans=="s"||ans=="S"){
		print("Image stacking is skipped.\n") ; goto finish
	}else{
		coadd_frames = yes
	}
 }
 if(coadd_frames){
	 coadd(irc_const, detsig, sigrej, maxitr, commode, comarea, skyarea, logfile, prefix, rejtype, rejsky, coadd_short, setwcs, skipl, sub_medsky, deltmp, verb)
 }


finish:
# Finish
 print ("\n")
 print ("### PIPELINE finished!! ###\n")
 print ("\n\n")


end
