# adjust_sky.cl -- To adjust sky level
# Created: Yoshifusa Ita, 19-Oct-05
# Updated: Yoshifusa Ita, 18-Aug-06 add subtracting median sky mode
#				    add a function to reject images taken during maneuver
# Add a function to consider sky with structure: Yoshifusa Ita, 16-Jan-06

procedure adjust_sky (prefixs, badconst, list_name, sky_area, data_max, sig_rej, max_itr, rej_sky, submedsky, verbose)
string  mode="al"

string prefixs    {"dDFlsa", prompt="Prefix of the filename"}
real   badconst   {-5000.,min=-10000.0,max=0., prompt="constants for bad/no data"}
string list_name  {"input.list", prompt="list name to be matched"}
int    sky_area   {2,min=1,max=2, prompt="sky matching area: 1:common area 2:whole area"}
real   data_max   {50000.,min=0.,max=60000., prompt="Initial upper limit for data range [ADU]"}
real   sig_rej    {3.,min=0.,max=100., prompt="Number of sigmas for imstat limits"}
int    max_itr    {10,min=1,max=10, prompt="Maximum number of iterations"}
bool   rej_sky = yes   {prompt="Remove image(s) with outlier sky level?\n"}
bool   submedsky = no  {prompt="Subtract median filtered sky?"}
bool   verbose = no    {prompt="Print verbose progress messages?\n"}
bool   rmmedsky = yes  {prompt="remove median filtered image?"}
int    x_box      {20,min=1,max=100, prompt="If submedsky=yes, x box car size"}
int    y_box      {20,min=1,max=100, prompt="If submedsky=yes, y box car size\n"}

struct *list0

begin

 real lower, upper, ll, ul
 real sigrej
 int maxitr, skyarea
 string area, detector, outname
 string listname, outlist, image, prefix, text
 int i, npix, nid
 real mean, median, modee, sigma
 bool verb, sub_medsky, rm_medsky, rejsky
 real dx, dy, angle
 real dxmax, dxmin, dymax, dymin
 int wx, wy, xmax, xmin, ymax, ymin
 real all_median, all_sigma
 int xbox, ybox


# Get query parameter
 prefix = prefixs
 listname = list_name
 skyarea = sky_area
 upper = data_max
 lower = badconst
 sigrej = sig_rej
 maxitr = max_itr
 rejsky = rej_sky
 verb = verbose
 sub_medsky = submedsky
 rm_medsky = rmmedsky
 xbox = x_box
 ybox = y_box


# get sky value
 outlist = "sky"//listname
 if( access(outlist) ){	delete(outlist, ver-) }
# $B$^$:!"(Bmatching$B$K@.8y$7$?$b$N$K$D$$$F$N$_!"%9%+%$$NCM$rD4$Y$k!#(B
 printf("! sed -e \'s/.fits.coo.1//g\' %s > %s\n", listname//".shift", listname//".shift.0") | cl
 list0 = listname//".shift.0"
 while (fscan (list0, image, dx, dy, angle, nid) != EOF) {
	if(nid > 1){
		text = "R"//image//".fits"
	        hselect(text, fields="DETECTOR", expr="yes") | scan(detector)
		if(skyarea == 1){ # $B6&DL$NNN0h$N%9%+%$$G%l%Y%k9g$o$;$7$?$$$J$i(B($B:#$O$+$J!<$j<jH4$-$@$,(B...)
			if(detector=="NIR"){ # NIR$B$J$i(B
				xmin = 306
				xmax = 717
				ymin = 256
				ymax = 767
			}else{
				xmin = 128
				xmax = 383
				ymin = 128
				ymax = 383
			}
		}else{ # $B%$%a!<%8A4BN$r;H$C$F!"%9%+%$$N%l%Y%k9g$o$;$7$?$$$J$i(B
			if(detector=="NIR"){ # NIR$B$J$i(B
				xmin = 1
				xmax = 1024
				ymin = 1
				ymax = 1024
			}else{
				xmin = 1
				xmax = 512
				ymin = 1
				ymax = 512
			}
		}
		area = "["//xmin//":"//xmax//","//ymin//":"//ymax//"]"
		imstat(text//area, fields="npix,mean,midpt,mode,stddev", lower=lower, upper=upper, nclip=maxitr, binwidth=0.1, format=no, cache=no) | scan(npix, mean, median, modee, sigma)
		i = 0
		while(i < maxitr){
			ll = mean - (sigrej*sigma)
			ul = mean + (sigrej*sigma)
			if (lower != INDEF && ll < lower) ll = lower
			if (upper != INDEF && ul > upper) ul = upper
			imstat(text//area, fields="npix,mean,midpt,mode,stddev", lower=ll, upper=ul, nclip=maxitr, binwidth=0.1, format=no, cache=no) | scan(npix, mean, median, modee, sigma)
			i += 1
		}
		printf("%s %10.4f %10.4f %10.4f %10.4f\n",image,mean,median,modee,sigma, >> outlist)
	 }
 }


# skypair $B%U%!%$%k$rD4$Y$F!"A42hA|$N(Bsky$B$NCM$H(Bsigma$B$r8+$F!"$=$N(Bmedian$B$rF@$k!#(B
 text = osfn("ircperl$")
 text = text//"median.sh"
 printf("! sh %s %s\n", text, outlist) | cl | scan(all_median, all_sigma)


# sky$B$,30$lCM$r;}$C$F$$$k%G!<%?$r$_$D$1$F%j%9%H$K$7$F$*$/!#(B
 if( rejsky ){
	 if( access(listname//".maneuver") ){ delete(listname//".maneuver", ver-) }
	 list0 = outlist
	 while (fscan (list0, image, mean, median, modee, sigma) != EOF) {
		if(median < all_median - all_sigma*5. || median > all_median + all_sigma*5.){ 
			printf("A%s.fits\n",image, >> listname//".maneuver")
		}
	 }
 }


# adjust sky
 list0 = outlist
 while (fscan (list0, image, mean, median, modee, sigma) != EOF) {
	text    = "R"//image//".fits"
	outname = "A"//image//".fits"
	if( access(outname) ){ imdel(outname, ver-) }
	if(sub_medsky){
		if( access("median.fits") ){ imdel("median.fits", ver-) }
		median(text, "median.fits", xbox, ybox, zloreject=0., boundary="constant", constant=0., verbose=verb)
		imarith(text, "-", "median.fits", outname, title="", divzero=0., hparams="", pixtype="real", calctype="double", verbose=verb, noact=no)
		if(!rm_medsky){
			if( access("median"//image//".fits") ){ imdel("median"//image//".fits", ver-) }
			imrename ("median.fits", "median"//image//".fits", verbose=no)
		}
	}else{
		imarith(text, "-", median, outname, title="", divzero=0., hparams="", pixtype="real", calctype="double", verbose=verb, noact=no)
	}
	imarith(outname, "+", all_median, outname, title="", divzero=0., hparams="", pixtype="real", calctype="double", verbose=verb, noact=no)
 }
 if( access("median.fits") ){ imdel("median.fits", ver-) }

end
