# calcshift.cl -- To calculate shift and rotation value between images
# Created: Yoshifusa Ita, 28-Dec-05

procedure calcshift (list_name, prefixs, sig_rej, max_itr, maxstar, minstar, minmatch, step, n_margin, verbose)
string  mode="al"

string list_name    {"ToBeCoadded.list", prompt="Name of the coadd list"}
string prefixs      {"dDFlsa", prompt="Prefix of the filename"}
real   sig_rej      {3.,min=0.,max=100., prompt="Number of sigmas for imstat limits"}
int    max_itr      {10,min=1,max=10, prompt="Maximum number of iterations"}
int    maxstar      {100, min=10, max=5000, prompt="Max # of stars in xymatching"}
int    minstar      {4, min=4, max=15, prompt="Min # of stars in xymatching"}
int    minmatch     {4, min=4, max=5000, prompt="Min # of stars matched"}
int    step         {5, min=1, max=10, prompt="Step"}
int    n_margin     {0, min=0, max=100, prompt="Margin pixels from image edge"}
real   tolerance    {1.5, min=0.1, max=10.0, prompt="The matching tolerance in pixels"}
bool   verbose = no {prompt="Print verbose progress messages?\n"}
struct *list0
struct *list1

begin

 string listname, prefix, lname, filename, text, output
 real   sigrej, tole
 int    i, maxitr, max_star, min_star, min_match, stp, margin, n_refstar, n_inpstar
 int    naxis1, naxis2, n_matched
 string refname, inpname, aot
 real   dx, dy, mag, x_ref, y_ref, x_in, y_in, anglex, angley, xrms, yrms
 bool   verb
 string filter, detector
 real   ra, dec
 int    expid, idnum, preidnum, subid, presubid, multi, ndither
 real   xoffset, yoffset, rotation, refrot, angle
 real   limit

# Get query parameters
 listname = list_name
 prefix = prefixs
 sigrej = sig_rej
 maxitr = max_itr
 max_star = maxstar
 min_star = minstar
 min_match = minmatch
 stp = step
 margin = n_margin
 verb = verbose
 tole = tolerance

 naxis1 = 0
 naxis2 = 0

# calculate shift
 list0 = listname
 while (fscan (list0, lname) != EOF){
 	list1 = lname
        i = 0              # file$BHV9f$r=i4|2=$9$k(B
	max_star = maxstar # max_star$B$r=i4|2=$9$k!#(B
	n_refstar = 0      # $B0LCV$N%j%U%!%l%s%9%$%a!<%8$G8!=P$5$l$?@1?t$r=i4|2=$9$k!#(B
	multi = 0          # $BJ#?t(Bpointing$B$r%+%&%s%H$9$k(Bcounter
	ndither = -1       # dithering$B2s?t$r%+%&%s%H$9$k(Bcounter
	preidnum = 0
	presubid = 0
	rotation = 0.0
	refrot   = 0.0
	if( access(lname//".shift") ){ delete(lname//".shift", ver-) }
	while (fscan (list1, filename, filter, ra, dec, expid, idnum, subid, aot) != EOF){
		text = prefix//filename//".fits"
		output = "R"//text # $B2sE>(B&$B%7%U%H8e$N2hA|$O(BR$B$r$D$1$k;v$K$9$k!#(B
		hselect(text, fields="DETECTOR", expr="yes") | scan(detector)

		# from here --> added 061021 $B2sE>3Q$H!"(Bxy$B%*%U%;%C%H$NM=B,CM$rF~$l$k(B
		# NIR$B$N$H$-$+$>$($9$.$K$J$k$,!"(BNIR$B$N$H$-$O=i4|9MN8$r$7$J$$$N$GL5;k$9$k!#(B
		if(expid == 1 || expid == 2){
			ndither += 1
		}
		if( preidnum != idnum || presubid != subid ){
			multi   += 1
			preidnum = idnum
			presubid = subid
			if(filter ==  "N2" || filter ==   "N3" || filter ==  "N4"){
				hselect(text, fields="PA-N", expr="yes") | scan(rotation)
			}else if(filter ==  "S7" || filter ==  "S9W" || filter == "S11"){
				hselect(text, fields="PA-S", expr="yes") | scan(rotation)
			}else if(filter == "L15" || filter == "L18W" || filter == "L24"){
				hselect(text, fields="PA-L", expr="yes") | scan(rotation)
			}else{
				printf("Filter name is wrong.\n")
				bye
			}
		}

		# rotation$B$N=i4|CM(B
		angle = rotation - refrot

		# MIRS&L$B$N%G%#%6%j%s%0$K$h$k(Bxy$B%*%U%;%C%H$N(Bfirst guess[pixels]
		if(multi == 1){
			# 1pointing$BL\$N%G!<%?$K$D$$$F$O(Bxyoffset$B$r9MN8(B
			if( aot=="IRC02" || aot=="IRC03" ){
				if(ndither == 0){
					xoffset =  0.0
					yoffset =  0.0
				}else if(ndither == 1){
					xoffset =  10.0
					yoffset = -1.0
					# 070615
					xoffset =  6.0
					yoffset = -1.0
				}else if(ndither == 2){
					xoffset =  12.0
					yoffset =  -9.0
					# 070615
					xoffset =  8.0
					yoffset =  -8.0
				}else if(ndither == 3){
					xoffset =  8.0
					yoffset = -9.0
					# 070615
					xoffset =  3.0
					yoffset = -10.0
				}else if(ndither == 4){
					xoffset = -1.70
					yoffset = -4.54
				}else{
					xoffset = INDEF
					yoffset = INDEF
				}
			}else{
				xoffset=INDEF
				yoffset=INDEF
			}
			limit = 50.0
		}else{
			# 2ointing$BL\0J9_$O!"2sE>3Q$@$19MN8(B
			xoffset = INDEF
			yoffset = INDEF
			# 070627 limit=200.0 -> 800.0
			limit = 800.0
		}
#		printf("debug: ndither:%d multi:%d dx:%f dy:%f dr:%f\n",ndither, multi, xoffset, yoffset, angle)
		# <-- to here added 061021

		if( i == 0 ){ # $B%G%#%6%j%s%00LCV4p=`%U%l!<%`$@$C$?$i(B
			refrot = rotation
			hselect(text, fields="NAXIS1, NAXIS2", expr="yes") | scan(naxis1, naxis2)
			refname = text//".coo.1"
			printf("! wc -l %s\n",refname) | cl | scan(n_refstar)
			if(n_refstar < maxstar){
				max_star = n_refstar
			}else{
				max_star = maxstar
			}
			if(detector=="NIR"){
				min_match = 15
				stp = 5
			}else{
				if(detector=="MIRS"){
					min_match = minmatch
				}else{
					min_match = 4
				}
				stp = 1
			}
			if(n_refstar <= 20){ # $B$b$H$b$H?t$,>/$J$$>l9g$O!">r7o$f$k$/$9$k!#(B
				stp = 1
				min_star = 4
				min_match = 4
				tole = 1.6
			}
			if( access("xy.reference") ){ delete("xy.reference", ver-) }
			printf("! head -n %d %s > xy.reference \n", max_star, refname) | cl
			printf("%s 0.0 0.0 0.0 999\n", refname, >> lname//".shift")
			if( access(output) ){ imdel(output, ver-) }
			imcopy(text, output, verbose=no)
		}else{
			inpname = text//".coo.1"

			# reference$B$K$b@1$,$9$/$J$9$.$F!"$=$b$=$b9g$o$;$i$l$=$&$K$J$$>l9g$OAa!9$K$"$-$i$a$k(B
			if(n_refstar <= 4){ goto fail }
			# input$B$K:G=i$+$i@1$,$9$/$J$$>l9g$b!"Aa!9$K$"$-$i$a$k(B
			printf("! wc -l %s\n",inpname) | cl | scan(n_inpstar)
			if(n_inpstar <= 4){ goto fail }
			# if( max_star > n_inpstar ){ max_star = n_inpstar }

			again:
			if(max_star <= 30){ # $B>/$J$/$J$C$F$-$?$i%a%C%7%e$r:Y$+$/(B&$B>r7o$r4K$/$9$k(B
				stp = 1
				min_star = 4
				min_match = 4
				tole = 1.6
			}

			# printf("debug %s %d %d %d %d %d\n",inpname,n_refstar,n_inpstar,min_match,min_star,max_star)

			# 070524 $B$"!<$C!*!*$3$3!*!*(B
			# <$B$G$O$J$/$F(B<=$B$8$c$J$$$H!"(Bmax_star$B$,(B4$B$G(Bmin_star$B$b(B4$B$N;~$K%@%a$K$J$k!*!*(B
			if(max_star <= min_star){
				fail:
				if(verb){
				        print("\t Matching failed!!!\n")
		 			printf("\t ref:%s inp:%s\n", refname, inpname)
				}
				printf("%s 999.99 999.99 999.99 0\n", inpname, >> lname//".shift")
			        printf("\t Matching failed! ref: %s inp: %s\n", refname, inpname, >> "calcshift.log")
			        goto endloop
 			}
			if( access("xy.reference.tmp") ){ delete("xy.reference.tmp", ver-) }
			printf("! head -n %d xy.reference > xy.reference.tmp\n", max_star) | cl
			if( access("xy.inp") ){ delete("xy.inp", ver-) }
			printf("! head -n %d %s > xy.inp \n", max_star, inpname) | cl
		 	if( access("matched") ){ delete("matched", ver-) }
			if(detector=="NIR"){
				# 070104 separation=9.0 -> 10.0
				# 070627 xyrotation=INDEF -> angle
				# 070627 separation=10.0 -> 4.0
				# 070627 ratio=10.0 -> 5.0
				xyxymatch("xy.inp", "xy.reference.tmp", "matched", tole, refpoints="", xin=INDEF, yin=INDEF, xmag=1., ymag=1., xrotation=angle, yrotation=angle, xref=INDEF, yref=INDEF, xcolumn=1, ycolumn=2, xrcolumn=1, yrcolumn=2, separation=4., matching="triangles", nmatch=30, ratio=5., nreject=10, xformat="%13.4f", yformat="%13.4f", interactive=no, verbose=verb, icommands="")
			}else{
#				printf("debug: x:%f y:%f r:%f\n",xoffset,yoffset,angle)
				# 070615 ratio=10.0 -> 5.0
				xyxymatch("xy.inp", "xy.reference.tmp", "matched", tole, refpoints="", xin=xoffset, yin=yoffset, xmag=1., ymag=1., xrotation=angle, yrotation=angle, xref=0.0, yref=0.0, xcolumn=1, ycolumn=2, xrcolumn=1, yrcolumn=2, separation=4., matching="triangles", nmatch=30, ratio=5., nreject=10, xformat="%13.4f", yformat="%13.4f", interactive=no, verbose=verb, icommands="")
			}
			! sed -e '/^$/d' matched | sed -e '/#/d' > matched.tmp
			if( !access("matched.tmp") ){ print("! touch matched.tmp\n") | cl }
			! \mv matched.tmp matched
			print("! wc -l matched\n") | cl | scan(n_matched)
 			if(n_matched < min_match){
  				max_star -= stp
  				goto again
 			}else{
				if(verb){
		 			printf("\t Successfully %d stars matched!!\n", n_matched)
		 			printf("\t ref:%s inp:%s\n", refname, inpname)
				}
			        printf("\t %3d stars matched! ref: %s inp: %s\n", n_matched, refname, inpname, >> "calcshift.log")
			}
	 		if( access("matched.inv") ){ delete("matched.inv", ver-) }
			fields("matched", "1,2,3,4", lines="1-", quit_if_miss=no, print_file_n=no, > "matched.inv" )
	        	if( access("database") ){ delete("database", ver-) }
        		if( access("summary.dat") ){ delete("summary.dat", ver-) }
			geomap("matched.inv", "database", 1, naxis1, 1, naxis2, transforms="record.dat", results="summary.dat", fitgeometry="rotate", function="polynomial", xxorder=2, xyorder=2, xxterms="full", yxorder=2, yyorder=2, yxterms="full", maxiter=maxitr, reject=sigrej, calctype="double", verbose=verb, interactive=no, graphics="stdgraph", cursor="")
			# $B>e$G5a$a$?JQ49%^%H%j%/%9$K$7$?$,$C$F!"2hA|$r%7%U%H(B&$B2sE>$9$k!#(B
			if( access(output) ){ imdel(output, ver-) }
			geotran(text, output, "database", "record.dat", geometry="linear", xin=INDEF, yin=INDEF, xshift=INDEF, yshift=INDEF, xout=INDEF, yout=INDEF, xmag=INDEF, ymag=INDEF, xrotation=INDEF, yrotation=INDEF, xmin=INDEF, xmax=INDEF, ymin=INDEF, ymax=INDEF, xscale=1.0, yscale=1.0, ncols=INDEF, nlines=INDEF, xsample=1., ysample=1., interpolant="linear", boundary="constant", constant=-9999, fluxconserve=yes, nxblock=2048, nyblock=2048, verbose=verb)
			print("! grep xrefmean database") | cl | scan(text, x_ref)
			print("! grep yrefmean database") | cl | scan(text, y_ref)
			print("! grep xmean database") | cl | scan(text, x_in)
			print("! grep ymean database") | cl | scan(text, y_in)
			print("! grep xshift database") | cl | scan(text, dx)
			print("! grep yshift database") | cl | scan(text, dy)
			print("! grep xrotation database") | cl | scan(text, anglex)
			print("! grep yrotation database") | cl | scan(text, angley)
			print("! grep xrms database") | cl | scan(text, xrms)
			print("! grep yrms database") | cl | scan(text, yrms)
			if( abs(dx) < limit && abs(dy) < limit ){
				printf("! \cp database %s%s.fits.shift\n",prefix,filename) | cl
				printf("%s %f %f %f %d\n", inpname, dx, dy, anglex, n_matched, >> lname//".shift")
			        printf("\t X and Y fit rms: %f %f\n", xrms, yrms, >> "calcshift.log")
			}else{
				printf("%s 999.99 999.99 999.99 0\n", inpname, >> lname//".shift")
			        printf("\t Matching failed! ref: %s inp: %s\n", refname, inpname, >> "calcshift.log")
			}
		}
		endloop:
		# max_star$B$r:FEY=i4|2=(B
		if(n_refstar < maxstar){
			max_star = n_refstar
			min_star = minstar
			min_match = minmatch
		}else{
			max_star = maxstar
			if(detector=="NIR"){
				min_match = 15
				stp = 5
			}else{
				min_match = minmatch
				stp = 1
			}
		}
		i+=1
        }
 }

# cleaning
 if( access("summary.dat") ){ delete("summary.dat", ver-) }
 if( access("database") ){ delete("database", ver-) }
 delete("xy.*", ver-)
 delete("matched*", ver-)

end
