# coadd.cl -- To coadd dithered images
# Created: Yoshifusa Ita, 14-Oct-05

procedure coadd (ircconst, det_sig, sig_rej, max_itr, com_mode, com_area, sky_area, logfile, prefixs, rejection, rej_sky, coaddshort, wcs, skip_L, submedsky, deltemp, verbose)
string  mode="al"

string ircconst     {"constants.database", prompt="IRC constants database file name"}
real   det_sig      {3.,min=1.,max=100000., prompt="Number of sigmas for detection limits"}
real   sig_rej      {3.,min=0.,max=100., prompt="Number of sigmas for imstat limits"}
int    max_itr      {10,min=1,max=10, prompt="Maximum number of iterations"}
string com_mode     {"average", prompt="combine mode: average/median"}
int    com_area     {1,min=1,max=2, prompt="stack area: 1:common area 2:whole area"}
int    sky_area     {2,min=1,max=2, prompt="sky matching area: 1:common area 2:whole area"}
string logfile      {"irclog", prompt="Output of the mkirclog"}
int    maxstar      {100, min=10, max=5000, prompt="Max # of stars in xymatching"}
int    minstar      {4, min=4, max=15, prompt="Min # of stars in xymatching"}
int    minmatch     {4, min=4, max=5000, prompt="Min # of stars matched"}
int    step         {5, min=1, max=10, prompt="Step"}
int    n_margin     {0, min=0, max=100, prompt="Margin pixels from image edge"}
string prefixs      {"T", prompt="prefix string"}
string rejection    {"sigclip", prompt="Type of rejection: none|minmax|ccdclip|crreject|sigclip|avsigclip|pclip"}
bool   rej_sky = yes   {prompt="Remove image(s) with outlier sky level?"}
bool   coaddshort = no {prompt="Coadd short exposure frames?"}
bool   wcs = no     {prompt="Try to compute wcs and write it in the header?"}
bool   skip_L = no  {prompt="Skip coadding MIRL images?"}
bool   submedsky = no   {prompt="Subtract median filtered sky in adjust_sky?"}
bool   deltemp = yes {prompt="Delete intermediate files?"}
bool   verbose = no {prompt="Print verbose progress messages?\n"}
struct *list0

begin

 string irc_const, commode, aot
 real   detsig, sigrej
 int    maxitr, comarea, skyarea
 bool   coadd_short, verb, setwcs, rejsky, skipl, sub_medsky, deltmp
 string filename, listname
 string text, bigimage
 int    expid, det_id
 string detector
 string libpath, exec, pcommand
 real   fwhm, fwhm_nir, fwhm_mirs, fwhm_mirl
 real   fullwell, fullwell_nir, fullwell_mirs, fullwell_mirl
 real   epadu, rnoise, exptime
 int    nline
 real   dx, dy, angle
 real   dxmin, dxmax, dymin, dymax
 int    i, j, max_star, min_star, min_match, n_matched, stp, margin
 string prefix, rejtype
 real   bad_const
 real   cpix1, cpix2
 int naxis1, naxis2, start1, start2, end1, end2


 print ("\n")
 print ("### COADD ###\n")

# Get query parameters
 irc_const = ircconst
 libpath = osfn("irclib$")
 detsig = det_sig
 sigrej = sig_rej
 maxitr = max_itr
 commode = com_mode
 comarea = com_area
 skyarea = sky_area
 coadd_short = coaddshort
 verb = verbose
 max_star = maxstar
 min_star = minstar
 min_match = minmatch
 stp = step
 margin = n_margin
 prefix = prefixs
 rejtype = rejection
 setwcs = wcs
 rejsky = rej_sky
 skipl = skip_L
 sub_medsky = submedsky
 deltmp = deltemp


# Read irc constants
 irc_const = libpath//irc_const
 # Full well [ADU]
 printf("! grep fullwell_nir  %s\n", irc_const) | cl | scan(text, fullwell_nir)
 printf("! grep fullwell_mirs %s\n", irc_const) | cl | scan(text, fullwell_mirs)
 printf("! grep fullwell_mirl %s\n", irc_const) | cl | scan(text, fullwell_mirl)
 # Mean FWHM [pixels]
 printf("! grep fwhm_nir      %s\n", irc_const) | cl | scan(text, fwhm_nir)
 printf("! grep fwhm_mirs     %s\n", irc_const) | cl | scan(text, fwhm_mirs)
 printf("! grep fwhm_mirl     %s\n", irc_const) | cl | scan(text, fwhm_mirl)
 # read bad/no data const
 printf("! grep baddata       %s\n", irc_const) | cl | scan(text, bad_const)


# make input file list
 print ("Making the input file list...\n")
 if( access("filename.list") ){ delete("filename.list", ver-) }
 ! cat irclog | perl -e 'while(<>){ chomp; @buf=split(/\s+/,$_); if($buf[0] !~ /\#/){ printf("%s\n",$buf[0])} }' > filename.list


# Source extract
 print ("Extracting sources...\n")
 print ("\t #This may take a while...\n")
 list0 = "filename.list"
 while (fscan (list0, filename) != EOF) {
 	filename = prefix//filename//".fits"
        hselect(filename, fields="DETECTOR", expr="yes") | scan(detector)
        hselect(filename, fields="GAIN"    , expr="yes") | scan(epadu)
        hselect(filename, fields="EXPID"   , expr="yes") | scan(expid)
        hselect(filename, fields="EXPTIME" , expr="yes") | scan(exptime)
        hselect(filename, fields="RNOISE"  , expr="yes") | scan(rnoise)
        hselect(filename, fields="NAXIS1"  , expr="yes") | scan(naxis1)
        hselect(filename, fields="NAXIS2"  , expr="yes") | scan(naxis2)
 	bigimage = "S"//filename
	if( access(bigimage) ){ imdel(bigimage, ver-) }
	if(detector == "NIR"){ # NIR
		mkimage (image=bigimage, option="make", value=-9999., ndim=2, dims="1024 1024", pixtype="real")
		start1 = 306
		start2 = 256
	}else{ # MIR-S/L
		mkimage (image=bigimage, option="make", value=-9999., ndim=2, dims="512 512",   pixtype="real")
		start1 = 128
		start2 = 128
	}
	end1 = start1 + naxis1 - 1
	end2 = start2 + naxis2 - 1
	imcopy(filename//"[1:"//naxis1//",1:"//naxis2//"]", bigimage//"["//start1//":"//end1//","//start2//":"//end2//"]", ver-)

	if( access("header.tmp.1") ){ delete("header.tmp.1", ver-) }
	imhead (filename, imlist="*.imh,*.fits,*.pl,*.qp,*.hhh", longheader=yes, userfields=yes, > "header.tmp.1")
        ! sed -n '/IRAF-TLM/,$p' header.tmp.1 > header.tmp.2
        mkheader (bigimage, "header.tmp.1", append=no, verbose=no)

	# add 061106
        # rewrite CPIX1 and CPIX2
        hselect (bigimage, fields="CPIX1", expr="yes") | scan(cpix1)
        hselect (bigimage, fields="CPIX2", expr="yes") | scan(cpix2)
	if(detector == "NIR"){
		cpix1 += 305.
		cpix2 += 255.
	}else{
		cpix1 += 127.
		cpix2 += 127.
	}
        ccdhedit (bigimage, paramete="CPIX1", value=cpix1, type="real")
        ccdhedit (bigimage, paramete="CPIX2", value=cpix2, type="real")

	if( access("header.tmp.1") ){ delete("header.tmp.1", ver-) }
	if( access("header.tmp.2") ){ delete("header.tmp.2", ver-) }
	if(detector=="NIR"){ # NIR
		fullwell = fullwell_nir
		fwhm     = fwhm_nir
		det_id   = 1
	}else if(detector=="MIRS"){ # MIRS
		fullwell = fullwell_mirs
		fwhm     = fwhm_mirs
		det_id   = 2
	}else if(detector=="MIRL"){ # MIRL
		fullwell = fullwell_mirl
		fwhm     = fwhm_mirl
		det_id   = 3
	}
	if( access(bigimage//".coo.0") ){ delete(bigimage//".coo.0", ver-) }

	if(!coadd_short && expid==1){ goto skip }
	if(skipl && detector=="MIRL"){ goto skip }

	source_extract(img=bigimage, detid=det_id, det_sig=detsig, sig_rej=sigrej, exp_time=exptime, data_max=fullwell, bad_data=bad_const, ep_adu=epadu, r_noise=rnoise, fwathm=fwhm, verbose=verb)
	if( access(bigimage//".coo.1") ){ delete(bigimage//".coo.1", ver-) }
	txdump(bigimage//".coo.0", "XCENTER,YCENTER,MAG", "SHARPNESS!=INDEF&&MAG!=INDEF", headers=no, parameters=no, >> bigimage//".coo.1")
#	if(detector=="NIR"){ # NIR
#		txdump(bigimage//".coo.0", "XCENTER,YCENTER,MAG", "SHARPNESS!=INDEF&&MAG!=INDEF", headers=no, parameters=no, >> bigimage//".coo.1")
#	}else if(detector=="MIRS"){ # MIRS
#		txdump(bigimage//".coo.0", "XCENTER,YCENTER,MAG", "SHARPNESS!=INDEF&&MAG!=INDEF", headers=no, parameters=no, >> bigimage//".coo.1")
#	}else{ # MIRL
#		txdump(bigimage//".coo.0", "XCENTER,YCENTER,MAG", "SHARPNESS!=INDEF&&MAG!=INDEF&&XCENTER>130&&XCENTER<381&&YCENTER>130&&YCENTER<381", headers=no, parameters=no, >> bigimage//".coo.1")
#	}
	printf("! sort -n -k 3,3 -o %s.coo.1 %s.coo.1\n", bigimage, bigimage) | cl # $BL@$k$$=g$GJB$SBX$((B
	if( access(bigimage//".coo.0") ){ delete(bigimage//".coo.0", ver-) }

	# $BCf4V%U%!%$%k$r>C$9(B yita 070516
	#	if(deltmp){ imdel(filename, yes, verify=no, default_acti=yes) }

	skip:
 }
 if( access("filename.list") ){ delete("filename.list", ver-) }


# make pair
 pcommand = osfn("ircperl$")
 pcommand = pcommand//"mkpair.pl" 
 printf("! %s\n",pcommand) | cl # mkpair.input$B$,:n$i$l$k(B
 if(skipl){
	! cat mkpair.input | sed -e '/ L15 /d' -e '/ L18W /d' -e '/ L24 /d' > mkpair.input.tmp
	! \mv mkpair.input.tmp mkpair.input
 }
 printf("! wc -l mkpair.input\n") | cl | scan(nline, text)
 nline = nline + 1
 exec = osfn("ircbin$")
 exec = exec//"mkpair"
 printf("! %s %d\n",exec, nline) | cl


# name of big images
 prefix = "S"//prefix


# calculate shift
 print ("Calculating XY shift...\n")
 print ("\t #This may take a while...\n")
 if( access("calcshift.log") ){ delete("calcshift.log", ver-) }
 if( access("pair.input") ){ delete("pair.input", ver-) }
 ! ls -1 pair*.list > pair.input
 pcommand = osfn("ircperl$")
 pcommand = pcommand//"mkcalcshift.pl"  #list_long$B$H(Blist_short$B$r:n$k(B
 printf("! %s\n",pcommand) | cl
# long exptime frame
 if( access("long_exp.input") ){ delete("long_exp.input", ver-) }
 ! ls -1 pair*.list_long > long_exp.input
 # add 061227 -->
 # help coadd
 exec = osfn("ircbin$")
 exec = exec//"lonesome"
 if( access("help.list") ){ delete("help.list", ver-) }
 # S$B$H(BL$B$@$1$N%j%9%H$r$D$/$k!#(B
 ! sed -e '/N2/d' -e '/N3/d' -e '/N4/d' long_exp.input > help.list
 list0 = "help.list"
 while (fscan (list0, filename) != EOF) { 
	printf("! %s %s %s\n",exec, filename, prefix) | cl
 }
 if( access("help.list") ){ delete("help.list", ver-) }
 # <-- add 061227
 calcshift(list_name="long_exp.input", prefixs=prefix, sig_rej=sigrej, max_itr=maxitr, maxstar=max_star, minstar=min_star, minmatch=min_match, step=stp, n_margin=margin, verbose=verb )
# short exptime frame
 if(coadd_short){
	 if( access("short_exp.input") ){ delete("short_exp.input", ver-) }
	 ! ls -1 pair*.list_short > short_exp.input
	 calcshift(list_name="short_exp.input", prefixs=prefix, sig_rej=sigrej, max_itr=maxitr, maxstar=max_star, minstar=min_star, minmatch=min_match, step=stp, n_margin=margin, verbose=verb )
 }


# adjust sky level
 print ("Adjusting sky level...\n")
 print ("\t #This may take a while...\n")
 list0 = "long_exp.input"
 while (fscan (list0, text) != EOF) {
	adjust_sky(prefixs=prefix, badconst=bad_const, list_name=text, sky_area=skyarea, data_max=50000, sig_rej=sigrej, max_itr=maxitr, rej_sky=rejsky, submedsky=sub_medsky, verbose=verb)
 }
 if(coadd_short){
	 printf("! %s short_exp.input\n",pcommand) | cl
	 list0 = "short_exp.input"
	 while (fscan (list0, text) != EOF) {
		adjust_sky(prefixs=prefix, badconst=bad_const, list_name=text, sky_area=skyarea, data_max=50000, sig_rej=sigrej, max_itr=maxitr, rej_sky=rejsky, submedsky=sub_medsky, verbose=verb)
	 }
 }

 if( !access("stacked_IM") ){ print("! mkdir stacked_IM\n") | cl }


# coadding images
 print ("Coadding images...\n")
 print ("\t #This may take a while...\n")
 if( access("coadd.failure") ){ delete("coadd.failure", ver-) }
 irc_stack(list_name="long_exp.input",  prefixs=prefix, lng_shrt=0, badconst=bad_const, sig_rej=sigrej, com_mode=commode, com_area=comarea, rejection=rejtype, rej_sky=rejsky, wcs=setwcs, verbose=verb)
 if(coadd_short){
	 irc_stack(list_name="short_exp.input", prefixs=prefix, lng_shrt=1, badconst=bad_const, sig_rej=sigrej, com_mode=commode, com_area=comarea, rejection=rejtype, rej_sky=rejsky, wcs=setwcs, verbose=verb)
 }


# cleaning
 if( access("pair.input") ){ delete("pair.input", ver-) }
 if( access("mkpair.input") ){ delete("mkpair.input", ver-) }


# move files
 ! \mv sigma*.fits stacked_IM
 ! \mv pl*.pl stacked_IM
 if( ! access("logs") ){ print("! mkdir logs\n") | cl }
 ! \mv skypair* logs
 if( access("calcshift.log") ){ print("! \\mv calcshift.log ./logs \n") | cl }

 print ("### COADD finished!! ###\n")

# $B%^%C%A%s%0$K<:GT$7$?$i(Bcoadd.failure$B$,:n@.$5$l$k!#(B
 if( access("coadd.failure") ){ 
	print("\t !! Warning !!\n")
	print("\t There were some images failed to be stacked.\n")
	print("\t Please look into the coadd.failure.\n")
 }

end
