# irc_stack.cl -- To stack images
#  
# Created: Yoshifusa Ita, 28-Dec-05
# Updated: Shinki Oyabu,  05-Dec-06 Trim pl and sigma file
# Updated: Yoshifusa Ita, 16-May-07 update pfov, edge.pix


procedure irc_stack (list_name, prefixs, lng_shrt, badconst, sig_rej, com_mode, com_area, rejection, rej_sky, wcs, verbose)
string  mode="al"

string list_name    {"ToBeCoadded.list", prompt="Name of the coadd list"}
string prefixs      {"dDFlsa", prompt="Prefix of the filename"}
int    lng_shrt     {0, min=0,max=1, prompt="0:long or 1:short"}
real   badconst     {-5000.,min=-100000.0,max=0., prompt="constants for bad/no data"}
real   sig_rej      {3.,min=0.,max=100., prompt="Number of sigmas for imstat limits"}
string com_mode     {"average", prompt="combine mode: average/median"}
int    com_area     {1,min=1,max=2, prompt="stack area: 1:common area 2:whole area"}
string rejection    {"sigclip", prompt="Type of rejection: none|minmax|ccdclip|crreject|sigclip|avsigclip|pclip"}
bool   rej_sky = yes {prompt="Remove image(s) with outlier sky level?\n"}
bool   wcs = no     {prompt="Try to compute wcs and write it in the header?"}
bool   verbose = no {prompt="Print verbose progress messages?\n"}
struct *list0
struct *list1
struct *list2

begin

 string listname, prefix, commode, filename, imgname
 int i, comarea, sigrej, nmatched, ibuf1, ibuf2, size, lngshrt
 int naxis1, naxis2
 real dxmin, dxmax, dymin, dymax, dx, dy, angle
 string temp, text, temp2, keyword, tempimgname
 int xmin, xmax, ymin, ymax, cxmin, cxmax, cymin, cymax
 string whole_area, common_area
 real bad_const
 string objectname, filter, rejtype
 real rdnoise, gain
 bool verb, setwcs, rejsky
 real cpix1, cpix2, crpix1, crpix2, pi, pfov
 real ltm11, ltm12, ltm21, ltm22, ltv1, ltv2
 real crval1, crval2, cd11, cd12, cd21, cd22
 int  detid


# Get query parameters
 listname = list_name
 prefix = prefixs
 sigrej = sig_rej
 commode = com_mode
 comarea = com_area
 bad_const = badconst
 lngshrt = lng_shrt
 rejtype = rejection
 verb = verbose
 rejsky = rej_sky
 setwcs = wcs
 pi = 3.141592653589793238462643383279

# coadding images
 tempimgname=mktemp ("tmp$ircstack")
	
 list0 = listname
 while (fscan (list0, filename) != EOF){
        dxmin =  10000.0 
        dxmax = -10000.0
        dymin =  10000.0
        dymax = -10000.0
	i = 0
	if( access("combine.list") ){ delete("combine.list", ver-) }
        list1 = filename
        while (fscan (list1, imgname, filter) != EOF){
		if( access("edge.pix") ){ delete("edge.pix", ver-) }
		# edge.pix$B$,<jBG$A$K$J$C$F$$$k$N$OHs>o$K7y$@$J$!!#(B
		if(filter == "N2" || filter == "N3" || filter == "N4"){
			detid = 1
			print("306 256\n306 771\n717 256\n717 771", > "edge.pix")
		}else if(filter == "S7"  || filter == "S9W"  || filter == "S11"){
			detid = 2
			print("128 128\n128 383\n383 128\n383 383", > "edge.pix")
		}else if(filter == "L15" || filter == "L18W" || filter == "L24"){
			detid = 3
			print("128 128\n128 383\n397 128\n397 383", > "edge.pix")
		}
		imgname = prefix//imgname//".fits"
		text = "A"//imgname
		if(i == 0){
			print(text, >> "combine.list")
		}else{
			if( access(imgname//".shift") ){
				if( access("edge.xy") ){ delete("edge.xy", ver-) }
				# $B;M6y$N2sE>8e$N:BI8$r7W;;$9$k(B
				geoxytran("edge.pix", "edge.xy", imgname//".shift", "record.dat", geometry="linear", direction="backward", xref=INDEF, yref=INDEF, xmag=INDEF, ymag=INDEF, xrotation=INDEF, yrotation=INDEF, xout=INDEF, yout=INDEF, xshift=INDEF, yshift=INDEF, xcolumn=1, ycolumn=2, calctype="double", xformat="%f", yformat="%f", min_sigdigit=7)
				list2 = "edge.xy"
			        while (fscan (list2, dx, dy) != EOF){
					if(dx<dxmin){ dxmin = dx }
					if(dx>dxmax){ dxmax = dx }
					if(dy<dymin){ dymin = dy }
					if(dy>dymax){ dymax = dy }
				}
				print(text, >> "combine.list")
			}else{
				printf("Can not combine %s \n", imgname)
				printf("Can not combine %s \n", imgname, >> "coadd.failure")
			}
		}
		i += 1
	}
	# combine.list$B$H(B*.maneuver$B$r8+Hf$Y$F!"(Bmanuever$BCf$N%G!<%?$O(Bcombine$B$7$J$$$h$&$K$9$k!#(B
	if( access(filename//".combine") ){ delete(filename//".combine", ver-) }
	if( access(filename//".maneuver") ){
		if( rejsky ){
			printf("! cat %s.maneuver combine.list | sort | uniq -u > %s.combine\n", filename, filename) | cl
		}else{
			printf("! \\cp combine.list %s.combine\n", filename) | cl
		}
	}else{
		printf("! \\cp combine.list %s.combine\n", filename) | cl
	}
	# $B%X%C%@$+$i>pJs$H$C$F$/$k(B
	hselect(imgname, fields="OBJECT", expr="yes") | scan(objectname)
	hselect(imgname, fields="GAIN",   expr="yes") | scan(gain)
	hselect(imgname, fields="RNOISE", expr="yes") | scan(rdnoise)
	if(lngshrt == 0){ # long exposure $B$@$C$?$i(B
		text = objectname//"_"//filter//"_long.fits" # $B:G=*E*$K$G$-$"$,$k%U%!%$%k$NL>A0(B
	}else{
		text = objectname//"_"//filter//"_short.fits" 
	}
#	temp = "C"//imgname # temporal stacked image
#	if( access(temp) ){ imdel(temp, ver-) }
	if( access(tempimgname) ){ imdel(tempimgname, ver-) }
	if( access(text) ){ imdel(text, ver-) }
	printf("! wc -l %s.combine\n", filename) | cl | scan(nmatched)
	if(nmatched > 1){ # $B0l$D0J>e$N(Bimage$B$,%^%C%A%s%0$K@.8y$7$F$$$?$i(B
		if( access("pl"//text//".pl") ){ imdel("pl"//text//".pl", ver-) }
		if( access("sigma"//text) ){ imdel("sigma"//text, ver-) }
		if( access("logfile") ){ delete("logfile", ver-) }

		combine ("@"//filename//".combine", tempimgname, plfile="pl"//tempimgname, sigma="sigma"//tempimgname, ccdtype="", subsets=no, delete=no, clobber=no, combine=commode, reject=rejtype, project=no, outtype="real", offsets="none", masktype="none", maskvalue=0., blank=0., scale="none", zero="none", weight="none", statsec="", lthreshold=bad_const, hthreshold=INDEF, nlow=1, nhigh=1, nkeep=1, mclip=yes, lsigma=sigrej, hsigma=sigrej, rdnoise=rdnoise, gain=gain, snoise="0.", sigscale=0.1, pclip=-0.5, grow=0)

		xmin  = int(abs(dxmin)) + 1
		xmax  = int(dxmax) - 1
		ymin  = int(abs(dymin)) + 1
		ymax  = int(dymax) - 1
		# $B$3$N%P!<%8%g%s$G$O(Bcommon area$BH4$-=P$7$r%5%]!<%H$7$F$J$$!#(B
		cxmin = xmin
		cxmax = xmax
		cymin = ymin
		cymax = ymax
#		printf("%d %d %d %d\n",xmin, xmax, ymin, ymax)

		# calcshift$B$K0l8+@.8y$7$F$$$k$h$&$K$_$($k$,<B$O13$H$$$&>l9g!"Nc30$,$*$3$C$F(Bpipeline$B$,Mn$k$N$G$=$l$rAK;_!#(B
		hselect(tempimgname, fields="NAXIS1, NAXIS2", expr="yes") | scan(naxis1, naxis2)
		if( xmin < 1 ) xmin = 1
		if( xmax > naxis1 ) xmax = naxis1
		if( ymin < 1 ) ymin = 1
		if( ymax > naxis2 ) ymax = naxis2
		if( cxmin < 1 ) cxmin = 1
		if( cxmax > naxis1 ) cxmax = naxis1
		if( cymin < 1 ) cymin = 1
		if( cymax > naxis2 ) cymax = naxis2

		whole_area  = "["//xmin//":"//xmax//","//ymin//":"//ymax//"]"
		common_area = "["//cxmin//":"//cxmax//","//cymin//":"//cymax//"]"
		if(com_area==1){
			imcopy(tempimgname//common_area, text, ver-)
			imcopy("pl"//tempimgname//".pl"//common_area, "pl"//text//".pl", ver-)
			imcopy("sigma"//tempimgname//common_area, "sigma"//text, ver-)
			ccdhedit(text, paramete="COMWAY", value="COMMON", type="string") 
			ccdhedit(text, paramete="COMAREA", value=common_area, type="string") 
			imdel("pl"//tempimgname//".pl", ver-)
			imdel("sigma"//tempimgname, ver-)
	
		}else{
			imcopy(tempimgname//whole_area, text, ver-)
			imcopy("pl"//tempimgname//".pl"//whole_area, "pl"//text//".pl", ver-)
			imcopy("sigma"//tempimgname//whole_area, "sigma"//text, ver-)
			ccdhedit(text, paramete="COMWAY", value="WHOLE", type="string") 
			ccdhedit(text, paramete="COMAREA", value=whole_area, type="string") 
			imdel("pl"//tempimgname//".pl", ver-)
			imdel("sigma"//tempimgname, ver-)
		}
		ccdhedit(text, paramete="COMBINE", value=commode, type="string") 
		# $B$I$N%U%!%$%k$rB-$7$?$N$+%X%C%@$KF~$l$k(B
		if( access("combined.im") ){ delete("combined.im", ver-) }
		! grep fits logfile | sed -e '/=/d' | sed -e 's/.....$//' | perl -e '$i=0; while(<>){chomp; $i++;  printf("%s IMCMB%03d\n",$_,$i); }' > combined.im
		list2 = "combined.im"
		while (fscan (list2, temp2, keyword) != EOF){
			ccdhedit (text, paramete=keyword, value=temp2, type="string") # $B%X%C%@$K$D$1$?$9!#(B
		}

	       	imdel(tempimgname, ver-)

		# $B4J0W(Bwcs$B$E$1(B
		# $BI,MW$J>pJs$r$H$C$F$/$k(B
		ltm11 = 0.0
		ltm12 = 0.0
		ltm21 = 0.0
		ltm22 = 0.0
		hselect (text, fields="CPIX1",  expr="yes") | scan(cpix1)
		hselect (text, fields="CPIX2",  expr="yes") | scan(cpix2)
		hselect (text, fields="LTM1_1", expr="yes") | scan(ltm11)
		hselect (text, fields="LTM1_2", expr="yes") | scan(ltm12)
		hselect (text, fields="LTM2_1", expr="yes") | scan(ltm21)
		hselect (text, fields="LTM2_2", expr="yes") | scan(ltm22)
		hselect (text, fields="LTV1",   expr="yes") | scan(ltv1)
		hselect (text, fields="LTV2",   expr="yes") | scan(ltv2)
		if(detid==3){
			ltv2 += 256
		}
		# $B$$$i$s$N$r>C$9(B
		hedit (text, "CPIX1",    "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
		hedit (text, "CPIX2",    "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
		hedit (text, "WCSDIM"  , "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
		hedit (text, "LTM3_3"  , "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
		hedit (text, "WAXMAP01", "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
		hedit (text, "WAT0_001", "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
		hedit (text, "WAT1_001", "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
		hedit (text, "WAT2_001", "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
		hedit (text, "WAT3_001", "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
		if(detid==1){
			hselect (text, fields="RA-N",  expr="yes") | scan(crval1)
			hselect (text, fields="DEC-N", expr="yes") | scan(crval2)
			hselect (text, fields="PA-N",  expr="yes") | scan(angle)
			pfov = 1.446/3600.
		}else if(detid==2){
			hselect (text, fields="RA-S",  expr="yes") | scan(crval1)
			hselect (text, fields="DEC-S", expr="yes") | scan(crval2)
			hselect (text, fields="PA-S",  expr="yes") | scan(angle)
			pfov = 2.340/3600.
		}else if(detid==3){
			hselect (text, fields="RA-L",  expr="yes") | scan(crval1)
			hselect (text, fields="DEC-L", expr="yes") | scan(crval2)
			hselect (text, fields="PA-L",  expr="yes") | scan(angle)
			pfov = 2.384/3600.
		} else {
			print ("detector ID should be 1:NIR, 2:MIRS or 3MIRL.")
			bye
		}
		# $BI,MW$J>pJs$r7W;;$7$F(B
#		crpix1 = ltm11*cpix1 + ltm12*cpix2 + ltv1
#		crpix2 = ltm21*cpix1 + ltm22*cpix2 + ltv2
		crpix1 = cpix1 + ltv1
		crpix2 = cpix2 + ltv2
		cd11 = -pfov *  cos(angle*pi/180.)
		cd12 = -pfov * -sin(angle*pi/180.)
		cd21 =  pfov *  sin(angle*pi/180.)
		cd22 =  pfov *  cos(angle*pi/180.)
		# hedder$B$K=q$-9~$`(B
	        ccdhedit (text, paramete="WCSROOT",  value="AOCS",         type="string")
	        ccdhedit (text, paramete="RADECSYS", value="FK5",          type="string")
	        ccdhedit (text, paramete="EQUINOX",  value=2000.,          type="real")
	        ccdhedit (text, paramete="WCSDIM",   value=2,              type="integer")
	        ccdhedit (text, paramete="CTYPE1",   value="RA---TAN",     type="string")
	        ccdhedit (text, paramete="CTYPE2",   value="DEC--TAN",     type="string")
	        ccdhedit (text, paramete="CRVAL1",   value=crval1,         type="real")
	        ccdhedit (text, paramete="CRVAL2",   value=crval2,         type="real")
	        ccdhedit (text, paramete="CRPIX1",   value=crpix1,         type="real")
	        ccdhedit (text, paramete="CRPIX2",   value=crpix2,         type="real")
	        ccdhedit (text, paramete="CD1_1",    value=cd11,           type="real")
	        ccdhedit (text, paramete="CD1_2",    value=cd12,           type="real")
	        ccdhedit (text, paramete="CD2_1",    value=cd21,           type="real")
	        ccdhedit (text, paramete="CD2_2",    value=cd22,           type="real")
	        ccdhedit (text, paramete="WAT0_001", value="system=image", type="string")
	        ccdhedit (text, paramete="WAT1_001", value="wtype=tan axtype=ra", type="string")
	        ccdhedit (text, paramete="WAT2_001", value="wtype=tan axtype=dec",type="string")

		# coadd$B$7$F$G$->e$,$C$?%U%!%$%k$r(B./stacked_IM$B$K0\F0(B
		printf("! \\mv %s ./stacked_IM\n", text) | cl

		# 2MASS$B$HHf$Y$F(Bwcs$B$E$1$9$k>l9g(B
		if (setwcs) putwcs("./stacked_IM/"//text)

	}else{ # $B4p=`%U%l!<%`0J30!"A4A3%^%C%A$7$F$$$J$+$C$?$i(B
		printf("Images are not matched at all in %s.\n", imgname)
	}
#       	delete("@combine.list", ver-)
 }
 if( access("logfile") ){ delete("logfile", ver-) }
 if( access("combined.im") ){ delete("combined.im", ver-) }

# cleaning
 if( access("combine.list") ){ delete("combine.list", ver-) }
 if( access("edge.pix") ){ delete("edge.pix", ver-) }
 if( access("edge.xy") ){ delete("edge.xy", ver-) }

end

