# putwcs.cl -- To put wcs to a image
# by matching 2MASS catalog coordinates.
# Created: Yoshifusa Ita, 30-Jun-06
# Updated: Yoshifusa Ita, 18-Jul-06  Delete unnecessary headers before putting new wcs
# Updated: Shinki Oyabu,  09-Dec-06  Wildcard input is available.

procedure putwcs (inlist)
string  mode="al"

string inlist {"input.fits", prompt="input fits file name"}
real   foview   {14.0, min=1., max=16., prompt="FOV of the image"}
int    maxstar  {100, min=50, max=5000, prompt="Max # of stars in xymatching"}
int    minstar  {5, min=4, max=15, prompt="Min # of stars in xymatching"}
int    minmatch {6, min=4, max=9999, prompt="Min # of stars matched"}
int    step     {1, min=1, max=10, prompt="Step"}
real   sig_rej  {3.,min=0.,max=100., prompt="Number of sigmas for imstat limits"}
real   det_sig  {3.,min=1.,max=100., prompt="Detection threshold in sigma"}
real   tolerance {1.5, min=0.1, max=10.0, prompt="The matching tolerance in pixels"}
string ircconst {"constants.database", prompt="IRC constants database file name"}
bool   verbose = no {prompt="Print verbose progress messages?\n"}
struct *list0,*imglist


begin

 string fname, irc_const
 real fov, sigrej, detsig
 int max_star, min_star, min_match, stp, det_id
 string text, pcommand, exec, libpath
 int i, n_matched, best_order, order
 real ra, dec, pa, pfov, fwhm, ftmp
 real xrms, yrms, tot_rms
 int naxis1, naxis2
 real epadu, exptime, rnoise, tole
	
 string imginlist,infile,filename
	
 imginlist=inlist
 infile=mktemp("tmp$putwcs");
 sections(imginlist,option="root", > infile)
 imglist=infile


 print ("\n")
 print ("### PUTWCS ###\n")

	
 while(fscan(imglist,filename) != EOF){
# get query parameters
	fname = filename
	fov   = foview
	max_star = maxstar
	min_star = minstar
	min_match = minmatch
	stp = step
	sigrej = sig_rej
	detsig = det_sig
	irc_const = ircconst
	verb = verbose
	tole = tolerance

# read ra and dec from header
	print ("\n")
	print ("Read RA and DEC from header...\n")
	if( access("radec.dat") ){ delete("radec.dat", ver-) }
	hselect(fname, fields="DETECTOR", expr="yes") | scan(text)
	if(text == "NIR"){
		det_id = 1
	}else if(text == "MIRS"){
		det_id = 2
	}else if(text == "MIRL"){
		det_id = 3
	}else{
		print ("something wrong with the header.")
		bye
	}

	if(det_id == 1){ # NIR
		hselect(fname, fields="$I, RA-N, DEC-N, PA-N, NAXIS1, NAXIS2", expr="yes", > "radec.dat")
		pfov = 1.446
	} else if(det_id == 2){ # MIRS
		hselect(fname, fields="$I, RA-S, DEC-S, PA-S, NAXIS1, NAXIS2", expr="yes", > "radec.dat")
		pfov = 2.340
	} else if(det_id == 3){ # MIRL
		hselect(fname, fields="$I, RA-L, DEC-L, PA-L, NAXIS1, NAXIS2", expr="yes", > "radec.dat")
		pfov = 2.384
	} else {
		print ("detector ID should be 1:NIR, 2:MIRS or 3:MIRL.")
		bye
	}
	printf("! wc -w radec.dat\n") | cl | scan(i, text)
	if(i == 6){
		printf("! cat radec.dat\n") | cl | scan(text, ra, dec, pa, naxis1, naxis2)
	}else{
		printf("Could'nt find RA DEC in the header\n")
		bye
	}
	if( access("radec.dat") ){ delete("radec.dat", ver-) }
	printf("\t RA %s  DEC %s  PA %s \n", ra, dec, pa)
	print("\n")
		

# $B0-$5$r$9$k%X%C%@$r>C$9(B
	ccdhedit (fname, paramete="WCSDIM", value=2, type="integer")
	hedit (fname, "LTM3_3"  , "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
	hedit (fname, "WAXMAP01", "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
	hedit (fname, "WAT3_001", "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
# hedit (fname, "WCSDIM"  , "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
# hedit (fname, "WAT0_001", "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
# hedit (fname, "WAT1_001", "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
# hedit (fname, "WAT2_001", "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)


# download 2mass catalog data
	print ("\n")
	print ("Downloading 2mass catalog...\n")
	pcommand = osfn("ircperl$")
	pcommand = pcommand//"get2mass.pl"
	printf("! %s %s %s %f\n", pcommand, ra, dec, fov) | cl

# format 2mass result
	pcommand = osfn("ircperl$")
	pcommand = pcommand//"format2mass.pl"
	printf("! %s 2mass.out\n",pcommand) | cl
	delete("2mass.out", ver-)

# convert 2mass radec to wcs xy
	exec = osfn("ircbin$")
	exec = exec//"convert2mass"
	printf("! %s 2mass.radec %f %f %f\n", exec, ra, dec, pfov) | cl
	delete("2mass.radec", ver-)

# read fwhm from ircconst
	libpath = osfn("irclib$")
	irc_const = libpath//irc_const
	if(det_id == 1){ # NIR
		printf("! grep fwhm_nir  %s\n", irc_const) | cl | scan(text, fwhm)
	}else if(det_id == 2){ # MIRS
		printf("! grep fwhm_mirs %s\n", irc_const) | cl | scan(text, fwhm)
	}else if(det_id == 3){ # MIRL
		printf("! grep fwhm_mirl %s\n", irc_const) | cl | scan(text, fwhm)
	}

# source extraction
	print ("Extracting sources...\n")
	hselect(fname, fields="GAIN"    , expr="yes") | scan(epadu)
	hselect(fname, fields="EXPTIME" , expr="yes") | scan(exptime)
	hselect(fname, fields="RNOISE"  , expr="yes") | scan(rnoise)
	if( access(fname//".coo.0") ){ delete(fname//".coo.0", ver-) } 
	source_extract2(fname, detid=det_id, det_sig=detsig, sig_rej=sigrej, exp_time=exptime, data_max=50000, bad_data=-1000., ep_adu=epadu, r_noise=rnoise, fwathm=fwhm, verbose=verb)
		
# sort & textdump
	# $BL@$i$+$K2hLL$N$=$H$K$"$k@1$r$H$j$N$>$/(B 
	if(det_id==1){
	        ! awk '{if(($4<220)&&($4>-220)&&($5<150)&&($5>-270)){print $0}}' 2mass.wcs > 2mass.wcs.2
	}else if(det_id==2){
	        ! awk '{if(($4<140)&&($4>-140)&&($5<140)&&($5>-140)){print $0}}' 2mass.wcs > 2mass.wcs.2
	}else if(det_id==3){
	        ! awk '{if(($4<130)&&($4>-130)&&($5<130)&&($5>-130)){print $0}}' 2mass.wcs > 2mass.wcs.2
	}else{
	       bye
	}
        ! \mv 2mass.wcs.2 2mass.wcs
	# 2mass$B%+%?%m%0$rL@$k$$=gHV$KJB$SBX$($k!#(B
	if(det_id == 1){
		! sort -n -k 6 -o reference.tmp.xy 2mass.wcs
		! awk '{if($6>10)print}' reference.tmp.xy > reference.xy
	        ! \rm -rf reference.tmp.xy
	}else{
		! sort -n -k 6 -o reference.xy 2mass.wcs
	}
	print("! wc -l reference.xy\n") | cl | scan(i, text)
	if(max_star > i){ max_star = i}


# input$B@1%+%?%m%0$rL@$k$$=gHV$KJB$SBX$($k!#(B
	text = fname//".coo.0"
	if( access("image.xy") ){ delete("image.xy", ver-) }
	txdump(text, "XCENTER,YCENTER,MAG", "yes", headers=no, parameters=no, >> "image.xy")
	! sort -n -k 3,3 -o image.xy image.xy 
	print("! wc -l image.xy\n") | cl | scan(i, text)
	if( max_star > i ){ max_star = i}
		
# matching reference.xy and image.xy
	print ("Matching 2mass coordinates...\n")
		
	again:
	if(max_star < min_star){
		print ("\t Matching failed!!!\n")
		goto finish
	}
	if( access("xy.inp") ){ delete("xy.inp", ver-) }
	if( access("xy.ref") ){ delete("xy.ref", ver-) }
	printf("! head -n %d image.xy > xy.inp\n", max_star) | cl
	printf("! head -n %d reference.xy > xy.ref\n", max_star) | cl
	if( access("matched") ){ delete("matched", ver-) }
	xyxymatch("xy.inp", "xy.ref", "matched", tole, refpoints="", xin=INDEF, yin=INDEF, xmag=1.0, ymag=1.0, xrotation=pa, yrotation=pa, xref=0.0, yref=0.0, xcolumn=1, ycolumn=2, xrcolumn=4, yrcolumn=5, separation=5., matching="triangles", nmatch=30, ratio=5., nreject=10, xformat="%13.4f", yformat="%13.4f", interactive=no, verbose=verb, icommands="")
# $B6uGr9T$H%3%a%s%H9T$r<h$j=|$/(B
	! sed -e '/^$/d' matched | sed -e '/#/d' > matched.tmp 
	if( !access("matched.tmp") ){ print("! touch matched.tmp\n") | cl }
	! \mv matched.tmp matched
	print("! wc -l matched\n") | cl | scan(n_matched)
	if(n_matched < min_match){
		max_star -= stp
		goto again
	}else{
		goto success
	}

	success:
	printf("\t Successfully %d stars matched!! \n\n", n_matched)


# calculate wcs coordinates and put it in the header
	if( access("matched.inv") ){ delete("matched.inv", ver-) }
	fields("matched", "3,4,1,2", lines="1-", quit_if_miss=no, print_file_n=no, > "matched.inv" )
	pcommand = osfn("ircperl$")
	pcommand = pcommand//"wcs2mass.pl"
	printf("! %s 2mass.wcs\n", pcommand) | cl

# check matched stars if they were real
	print("Checking...\n")
	print("! wc -l ccmap.input\n") | cl | scan(n_matched)
	if(n_matched < 4){
		print("\t They were phantom stars that were matched!!\n")
		print("\t Matching was actually failed.\n")
		print("\t Matching failed!!!\n")
		goto finish
	}else{
		print("\t Good!!!\n")
	}


# use ccmap to calculate transformation matrix
	print("Calculating transformation matrix...\n")
	best_order = 2
	ftmp = 50000.0
	for(order=2 ; order<5 ; order+=1){
		if( access("database2")    ){ delete("database2", ver-) }
		if( access("summary2.dat") ){ delete("summary2.dat", ver-) }
		ccmap("ccmap.input", "database2", solutions="solution", images=fname, results="summary2.dat", xcolumn=6, ycolumn=7, lngcolumn=2, latcolumn=3, xmin=1., xmax=naxis1, ymin=1., ymax=naxis2, lngunits="degrees", latunits="degrees", insystem="j2000", refpoint="coords", lngref="INDEF", latref="INDEF", refsystem="INDEF", lngrefunits="degrees", latrefunits="degrees", projection="tan", fitgeometry="general", function="polynomial", xxorder=order, xyorder=order, xxterms="full", yxorder=order, yyorder=order, yxterms="full", maxiter=10, reject=sig_rej, update=no, pixsystem="logical", verbose=verb, interactive=no, graphics="stdgraph", cursor="")
		if( access("tmp.txt") ){ delete("tmp.txt", ver-) }
		! grep "wcs rms" summary2.dat | perl -e 'while(<>){chomp; @buf1=split(/\s+/,$_); printf("%f %f\n",$buf1[6],$buf1[7]);}' > tmp.txt
		list0 = "tmp.txt"
		i = fscan(list0, xrms, yrms)
		if( access("tmp.txt") ){ delete("tmp.txt", ver-) }
		print("! grep Warning summary2.dat\n") | cl | scan(text)
       		tot_rms = xrms*xrms + yrms*yrms
#		printf("%f %f\n",ftmp,tot_rms)
		if(tot_rms > 1.5){
			printf("\t Wrong match!! matching stars again.\n")
			max_star = max_star - 1
			goto again
		}
		if(text=="#"){
			printf("\t The rms in %2dth order fit-  # Warning: singular fit\n", order)
		}else{
			printf("\t The rms in %2dth order fit-  x:%10.5f, y:%10.5f\n", order, xrms, yrms)
			if(tot_rms < ftmp){
				best_order = order
				ftmp = tot_rms
			}
		}
	}
	printf("The best order is: %d\n", best_order)
	order = best_order
	if( access("database2") ){ delete("database2", ver-) }
	if( access("summary2.dat") ){ delete("summary2.dat", ver-) }
# $B0lHV(Brms$B$N>.$5$$(Border$B$G$b$&0lEY%U%#%C%H$9$k!#(B $B:#2s$O(Bupdate=yes$B$K$7$F(BWCS$B$r=q$-$3$s$G$7$^$&!#(B
	ccmap("ccmap.input", "database2", solutions="solution", images=fname, results="summary2.dat", xcolumn=6, ycolumn=7, lngcolumn=2, latcolumn=3, xmin=1., xmax=naxis1, ymin=1., ymax=naxis2, lngunits="degrees", latunits="degrees", insystem="j2000", refpoint="coords", lngref="INDEF", latref="INDEF", refsystem="INDEF", lngrefunits="degrees", latrefunits="degrees", projection="tan", fitgeometry="general", function="polynomial", xxorder=order, xyorder=order, xxterms="full", yxorder=order, yyorder=order, yxterms="full", maxiter=10, reject=sig_rej., update=yes, pixsystem="logical", verbose=verb, interactive=no, graphics="stdgraph", cursor="")
		
# 2mass WCS flag
	ccdhedit (fname, paramete="WCSROOT", value="2MASS", type="string")
		
		
	finish:

# cleaning
	if( access("ccmap.input") ){ delete("ccmap.input", ver-) }
	if( access("matched") ){ delete("matched", ver-) }
	if( access("matched.inv") ){ delete("matched.inv", ver-)} 
	if( access("matched_xy") ){ delete("matched_xy", ver-)} 
	if( access("2mass.wcs") ){ delete("2mass.wcs", ver-) }
	if( access("NIR.radec") ){ delete("NIR.radec", ver-) }
	if( access("NIR.coo") ){ delete("NIR.coo", ver-) }
	if( access("database2") ){ delete("database2", ver-) }
	if( access("summary2.dat") ){ delete("summary2.dat", ver-) }
	if( access("xy.ref") ){ delete("xy.ref", ver-) }
	if( access(fname//".coo.0") ){ delete(fname//".coo.0", ver-) }
	if( access("image.xy") ){ delete("image.xy", ver-) }
	if( access("reference.xy") ){ delete("reference.xy", ver-) }
	if( access("xy.inp") ){ delete("xy.inp", ver-) }
 }

 print("### PUTWCS finished!! ###\n")

 del(infile)

end

