# source_extract.cl -- To extract sources
# Created: Yoshifusa Ita, 07-Jul-05
# Updated: Yoshifusa Ita, 16-May-07 remove cosmic_ray rejection

procedure source_extract (img, detid, det_sig, sig_rej, exp_time, data_max, bad_data, ep_adu, r_noise, fwathm, verbose)
string  mode="al"

string img        {"image.fits", prompt="image fits file name"}
int    detid      {1,min=1,max=3, prompt="Detector ID: 1NIR,2MIRS,3MIRL"}
real   det_sig    {3.,min=1.,max=1000., prompt="Number of sigmas for detection limits"}
real   sig_rej    {2.5,min=0.,max=100., prompt="Number of sigmas for imstat limits"}
real   exp_time   {51.4272,min=0.1,max=120., prompt="Integration time"}
real   data_max   {60000.,min=0.,max=99999., prompt="Initial upper limit for data range [ADU]"}
real   bad_data   {-5000.,min=-99999.,max=0., prompt="egnore any pixels below this level.[ADU]"}
real   ep_adu     {10.,min=1.,max=100., prompt="Analog to Digital unit/gain [electrons/ADU]"}
real   r_noise    {10.,min=1.,max=100., prompt="Read out noise [electrons]"}
real   fwathm     {1.,min=1.,max=50., prompt="Mean FWHM [pixels]"}
int    maxitr     {10,min=1,max=10, prompt="Maximum number of iterations"}
bool   verbose = no {prompt="Print verbose progress messages?\n"}
struct *list0

begin

 string image, statarea, originalname
 real detsig, exptime, upper, lower, epadu, rnoise, fwhm
 real skyval, sdev_sky
 real mean, sigma, median, modee
 int i, npix, det_id
 real ll, ul
 int maxiter
 real nsigrej
 real baddata

# Get query parameter
 image = img
 det_id = detid
 detsig = det_sig
 exptime = exp_time
 upper = data_max
# lower = bad_data
 lower = -1000
 epadu = ep_adu
 rnoise = r_noise
 fwhm = fwathm
 maxiter = maxitr
 nsigrej = sig_rej


# sky$B$N(Bstat$B$r$9$kNN0h(B
 if(det_id==1){
	statarea = "[308:715,257:635]" # imstat$B$G(Bsky$B$r7h$a$kNN0h(B
 }else if(det_id==2){
	statarea = "[160:379,130:379]"
 }else if(det_id==3){ # L$B$@$C$?$i(B
	statarea = "[142:372,138:371]"
 }


# S$B$H(BL$B$N>l9g$O!"%9%+%$$,$&$M$C$F$$$k$N$G!"(Bmedianbox$B%U%#%k%?$r$7$?2hA|$r0z$$$F(B
# $B%F%s%]%i%j$J%$%a!<%8$r:n$j!"$=$l$KBP$7$F(Bsource_extraction$B$9$k!#(B
 originalname = image
 if(det_id!=1){ # NIR$B$8$c$J$+$C$?$i(B
	if( access("median.fits") ){ imdel("median.fits", ver-) }
	if( access("skysub.fits") ){ imdel("skysub.fits", ver-) }
	median (image, "median.fits", 61, 61, zloreject=0., zhireject=upper, boundary="constant", constant=0., verbose=verb)
	imarith (image, "-", "median.fits", "skysub.fits", title="", divzero=0., hparams="", pixtype="real", calctype="double", verbose=verb, noact=no)
	if( access("median.fits") ){ imdel("median.fits", ver-) }
	image = "skysub.fits"
 }


# sky$B$N:G=i$N%m%P%9%H$JCM$rF@$k!#(B
 imstat(image//statarea, fields="npix,mean,midpt,mode,stddev", lower=lower, upper=upper, nclip=maxiter, binwidth=0.1, format=no, cache=no) | scan(npix, mean, median, modee, sigma)
# printf("debug %s %d %f %f %f %f\n",originalname, npix, mean,median,modee,sigma)
 i = 1
 while(i <= maxiter){
 	ll = mean - (nsigrej*sigma)
 	ul = mean + (nsigrej*sigma)
 	if (lower != INDEF && ll < lower) ll = lower
 	if (upper != INDEF && ul > upper) ul = upper
 	imstat(image//statarea, fields="npix,mean,midpt,mode,stddev", lower=ll, upper=ul, nclip=maxiter, binwidth=0.1, format=no, cache=no) | scan(npix, mean, median, modee, sigma)
 	i = i + 1
 }
# printf("debug2 %s %d %f %f %f %f\n",originalname, npix,mean,median,modee,sigma)
 skyval = median
 sdev_sky = sigma


# make parameter lists for daofind
 if( access("find.par") ) { delete("find.par", ver-) }
 if( access("data.par") ) { delete("data.par", ver-) }

 # 070104  sharplo=0.2 -> 0.3 , sharphi=1.0 -> 0.9 , roundlo=-1.0 -> -0.9 , roundhi=1.0 -> 0.9
 printf("threshold,r,h,%5.2f,,,\"Threshold in sigma for feature detection\"\nnsigma,r,h,1.5,,,\"Width of convolution kernel in sigma\"\nratio,r,h,1.,0.,1.,\"Ratio of minor to major axis of Gaussian kernel\"\ntheta,r,h,0.,0.,180.,\"Position angle of major axis of Gaussian kernel\"\nsharplo,r,h,0.3,,,\"Lower bound on sharpness for feature detection \"\nsharphi,r,h,0.9,,,\"Upper bound on sharpness for  feature detection\"\nroundlo,r,h,-0.9,,,\"Lower bound on roundness for feature detection\"\nroundhi,r,h,0.9,,,\"Upper bound on roundness for feature detection\"\nmkdetections,b,h,no,,,\"Mark detections on the image display ?\"\nmode,s,h,\"ql\",,,\n", detsig, >> "find.par")

 printf("scale,r,h,1.0,0.,,\"Image scale in units per pixel\"\nfwhmpsf,r,h,%5.2f,0.,,\"FWHM of the PSF in scale units\"\nemission,b,h,yes,,,\"Features are positive ?\"\nsigma,r,h,%8.3f,0.,,\"Standard deviation of background in counts\"\ndatamin,r,h,%8.1f,,,\"Minimum good data value\"\ndatamax,r,h,%8.1f,,,\"Maximum good data value\"\nnoise,s,h,\"poisson\",|poisson|,,\"Noise model\"\nccdread,s,h,\"\",,,\"CCD readout noise image header keyword\"\ngain,s,h,\"\",,,\"CCD gain image header keyword\"\nreadnoise,r,h,%5.2f,,,\"CCD readout noise in electrons\"\nepadu,r,h,%5.2f,,,\"Gain in electrons per count\"\nexposure,s,h,\"\",,,\"Exposure time image header keyword\"\nairmass,s,h,\"\",,,\"Airmass image header keyword\"\nfilter,s,h,\"\",,,\"Filter image header keyword\"\nobstime,s,h,\"\",,,\"Time of observation image header keyword\"\nitime,r,h,%8.4f,,,\"Exposure time\"\nxairmass,r,h,INDEF,,,\"Airmass\"\nifilter,s,h,INDEF,,,\"Filter\"\notime,s,h,INDEF,,,\"Time of observation\"\nmode,s,h,\"ql\",,,\n", fwhm, sdev_sky, lower, upper, rnoise, epadu, exptime, >> "data.par")


# Source extraction with daofind
 if( access(image//".coo.0") ){	delete(image//".coo.0", ver-) }
 if (!deftask ("noao.digiphot.apphot.daofind")) {
	noao.digiphot.apphot
 }
 if(det_id==1){ # NIR$B$@$C$?$i(B
	 daofind (image, output=image//".coo.0", starmap="", skymap="", datapars="data.par", findpars="find.par", boundary="nearest", constant=0., interactive=no, icommands="", gcommands="", wcsout=")_.wcsout", cache=")_.cache", verify=no, update=no, verbose=no, graphics="no", display="no")
 }else{
	 daofind ("skysub.fits", output=originalname//".coo.0", starmap="", skymap="", datapars="data.par", findpars="find.par", boundary="nearest", constant=0., interactive=no, icommands="", gcommands="", wcsout=")_.wcsout", cache=")_.cache", verify=no, update=no, verbose=no, graphics="no", display="no")
 }

# clean
 if( access("skysub.fits") ){ imdel("skysub.fits", ver-) }
 delete("find.par", ver-)
 delete("data.par", ver-)

end
