# anomalous_pix.cl -- To mask the dead/hot/bad pixels
# Created: Yoshifusa Ita, 08-Jul-05
# 09-Jul-05 - Add cleaning (Y. Ita)
# 15-Sep-05 - change to read database (Y. Ita)
# 09-May-07 - change calctype and pixtipe in imarith (Y. Ita)

procedure anomalous_pix (ircconst, logfile, prefixs, verbose)
string  mode="al"

string ircconst {"constants.database", prompt="IRC constants database file name"}
string logfile  {"irclog", prompt="output of the mkirclog"}
string prefixs  {"a", prompt="prefix string"}
bool   verbose = no {prompt="Print verbose progress messages?"}
struct *list0

begin

 string fname, outname
 string libpath
 string irc_const
 string maskfile, nmask, smask, lmask
 string prefix
 string detector
 bool verb

 print ("\n")
 print ("### ANOMALOUS_PIX ###\n")


# get query parameters
 libpath = osfn ("irclib$")
 irc_const = ircconst
 verb = verbose
 prefix = prefixs


# make input file list
 print ("Making the input file list...\n")
 if( access("filename.list") ){ delete("filename.list", ver-) }
 ! cat irclog | perl -e 'while(<>){ chomp; @buf=split(/\s+/,$_); if($buf[0] !~ /\#/){ printf("%s\n",$buf[0])} }' > filename.list


# Read irc constants
 irc_const = libpath//irc_const
 # Mask file name
 printf("! grep nir_anomalous  %s\n", irc_const) | cl | scan(text, nmask)
 printf("! grep mirs_anomalous %s\n", irc_const) | cl | scan(text, smask)
 printf("! grep mirl_anomalous %s\n", irc_const) | cl | scan(text, lmask)

# Masking
 print ("Masking anomalous pixels...\n")
 print ("\t #This may take a while...\n")
 list0 = "filename.list"
 while( fscan(list0, fname) !=EOF){
	fname = prefix//fname//".fits"
	hselect(fname, fields="DETECTOR", expr="yes") | scan(detector)
	outname = "a"//fname
	if( access(outname) ){ imdel (outname, yes, verify=no, default_acti=yes) }
	if(detector == "NIR"){ # NIR
		maskfile = libpath//"anomalous_pix/"//nmask
        }else if(detector == "MIRS"){ # MIRS
		maskfile = libpath//"anomalous_pix/"//smask
        }else if(detector == "MIRL"){ # MIRL
		maskfile = libpath//"anomalous_pix/"//lmask
	}
 	imarith (fname, "*", maskfile, outname, title="", divzero=0., hparams="", pixtype="real", calctype="real", verbose=verb, noact=no)
        # ircslice$BD>8e$N%U%!%$%k$r;D$9$?$a!"$"$($F(Bfname$B$O>C$5$J$$!#(B
 }

# cleaning
 if( access("filename.list") ){ delete("filename.list", ver-) }

 print ("### ANOMALOUS_PIX finished!! ###\n")

end
