# aspect_ratio.cl -- To resample the aspect ratio -> x:y=1:1
# Created: Yoshifusa Ita, 11-Apr-07

procedure aspect_ratio (ircconst, logfile, prefixs, deltemp, verbose)
string  mode="al"

string ircconst {"constants.database", prompt="IRC constants database file name"}
string logfile  {"irclog", prompt="output of the mkirclog"}
string prefixs  {"r", prompt="prefix string"}
bool   deltemp = yes {prompt="Delete intermediate files?"}
bool   verbose = no {prompt="Print verbose progress messages?"}
struct *list0

begin

 string fname, outname
 string libpath, text
 string irc_const
 string prefix
 string detector
 real   nx, ny, sx, sy, lx, ly, rx, ry, jacobian
 bool   verb, deltmp
 real   cpix1, cpix2


 print ("\n")
 print ("### ASPECT_RATIO ###\n")

# get query parameters
 libpath = osfn ("irclib$")
 irc_const = ircconst
 verb = verbose
 deltmp = deltemp
 prefix = prefixs


# make input file list
 print ("Making the input file list...\n")
 if( access("temp.list") ){ delete("temp.list", ver-) }
 ! cat irclog | perl -e 'while(<>){ chomp; @buf=split(/\s+/,$_); if($buf[0] !~ /\#/){ printf("%s\n",$buf[0])} }' > temp.list


# Read irc constants
 irc_const = libpath//irc_const
 # Mask file name
 printf("! grep NIRXaspect  %s\n", irc_const) | cl | scan(text, nx)
 printf("! grep NIRYaspect  %s\n", irc_const) | cl | scan(text, ny)
 printf("! grep MIRSXaspect %s\n", irc_const) | cl | scan(text, sx)
 printf("! grep MIRSYaspect %s\n", irc_const) | cl | scan(text, sy)
 printf("! grep MIRLXaspect %s\n", irc_const) | cl | scan(text, lx)
 printf("! grep MIRLYaspect %s\n", irc_const) | cl | scan(text, ly)


# Resampling -> 1:1
 print ("Resampling aspect ratio...\n")
 print ("\t #This may take a while...\n")
 list0 = "temp.list"
 while( fscan(list0, fname) !=EOF){
	fname = prefix//fname//".fits"
	hselect(fname, fields="DETECTOR", expr="yes") | scan(detector)
        hselect(fname, fields="CPIX1",    expr="yes") | scan(cpix1)
        hselect(fname, fields="CPIX2",    expr="yes") | scan(cpix2)
	outname = "e"//fname
	if( access(outname) ){ imdel (outname, yes, verify=no, default_acti=yes) }
	if(detector == "NIR"){ # NIR
		rx = nx
		ry = ny
        }else if(detector == "MIRS"){ # MIRS
		rx = sx
		ry = sy
        }else if(detector == "MIRL"){ # MIRL
		rx = lx
		ry = ly
	}
	magnify (fname, outname, rx, ry, x1=INDEF, x2=INDEF, dx=INDEF, y1=INDEF, y2=INDEF, dy=INDEF, interpolatio="linear", boundary="nearest", constant=0., fluxconserve=yes, logfile="")
#	# CRPIX$B$,JQ2=$9$k$N$r$*$C$+$1$k(B
#	cpix1 = rx * cpix1
#	cpix2 = ry * cpix2
#       ccdhedit(outname, paramete="CPIX1", value=cpix1, type="real")
#       ccdhedit(outname, paramete="CPIX2", value=cpix2, type="real")
#       fluxconserve=yes$B$K$J$C$F$$$k$N$G%d%3%S%"%s$,$+$+$C$?>uBV$K$J$C$F$$$k!#(B
#       $BNc(B:$BA4It(B1$B$N2hA|$r(B2x2$B$K$7$?>l9g!"(Bfluxconserve=yes$B$@$H!"JQ498e$N(B1$B%T%/%;%k$NCM$O(B0.25$B$K$J$k!#(B
#	# $B%d%3%S%"%s$r$+$1$?$j$7$F3NG'MQ!#(B
#	jacobian = rx * ry
#	imarith (outname, "*", jacobian, outname, title="", divzero=0., hparams="", pixtype="real", calctype="double", verbose=verb, noact=no)
        if (deltmp) imdel(fname, yes, verify=no, default_acti=yes)
 }

# cleaning
 if( access("temp.list") ){ delete("temp.list", ver-) }

 print ("### ASPECT_RATIO finished!! ###\n")

end
