# cosmic_ray.cl -- Cosmic  ray  events in each input image are detected and replaced by
#                  the average of the four neighbors.
# Created: Yoshifusa Ita, 02-May-07

procedure cosmic_ray (ircconst, logfile, prefixs, deltemp, verbose)
string  mode="al"

string ircconst {"constants.database", prompt="IRC constants database file name"}
string logfile  {"irclog", prompt="output of the mkirclog"}
string prefixs  {"a", prompt="prefix string"}
bool   deltemp = yes {prompt="Delete intermediate files?"}
bool   verbose = no {prompt="Print verbose progress messages?"}
struct *list0

begin

 string fname, outname, libpath, irc_const, prefix
 bool verb, deltmp
 string text, detector, area
 int npix
 real mean, median, modee, sigma
 real thresh, fluxratio


 print ("\n")
 print ("### COSMICRAY ###\n")


# get query parameters
 libpath = osfn ("irclib$")
 irc_const = ircconst
 prefix = prefixs
 verb = verbose
 deltmp = deltemp


# make input file list
 print ("Making the input file list...\n")
 if( access("filename.list") ){ delete("filename.list", ver-) }
 ! cat irclog | perl -e 'while(<>){ chomp; @buf=split(/\s+/,$_); if($buf[0] !~ /\#/){ printf("%s\n",$buf[0])} }' > filename.list


# Subtracting scattering light pattern
 print ("Detect and replace cosmic rays...\n")
 print ("\t #This may take a while...\n")
 list0 = "filename.list"
 while( fscan(list0, fname) !=EOF){
	fname = prefix//fname//".fits"
	outname = "C"//fname
        if( access(outname) ){ imdel (outname, yes, verify=no, default_acti=yes) }
	# $B%X%C%@$rFI$s$G!"(BDETECTOR$B$rD4$Y$k(B
        hselect(fname, fields="DETECTOR", expr="yes") | scan(detector)
	if(detector != "NIR"){
		# $B%$%a!<%8%(%j%"$NDj5A(B
		if(detector == "MIRS"){
		        area = "[40:256,1:256]"
		}else if(detector == "MIRL"){
		        area = "[1:220,82:200]"
		}else{
			print("Detector name is wrong!!\n")
			bye
		}
		# imaging$BNN0h$N(Bstat$B$r$9$k(B
		imstat(fname//area, fields="npix,mean,midpt,mode,stddev", lower=0, upper=10000, lsigma=3, usigma=3, nclip=100, binwidth=0.1, format=no, cache=no) | scan(npix, mean, median, modee, sigma)
		# $B8!=P4oKh$K%Q%i%a!<%?$r$+$($k(B
		thresh = 3.0*sigma
		if(detector == "MIRS"){
			fluxratio = 3.0
		}else if(detector == "MIRL"){
			fluxratio = 3.0
		}else{
			print("Detector name is wrong!!\n")
			bye
		}
		# cosmicrays$B$r;H$C$F=|5n(B
		cosmicrays (fname, outname, "yes", crmasks="tmp.pl", threshold=thresh, fluxratio=fluxratio, npasses=5, window="5", interactive=no, train=no, objects="", savefile="", plotfile="", graphics="stdgraph", cursor="")

	}else{ # $B$=$l0J30$O$=$N$^$^%3%T!<(B
                imcopy (fname, outname, verbose=verb)
	}
        if (deltmp) imdel(fname, yes, verify=no, default_acti=yes)
 }

# cleaning
 if( access("tmp.pl") ){ delete("tmp.pl", ver-) }
 if( access("filename.list") ){ delete("filename.list", ver-) }

 print ("### COSMICRAY finished!! ###\n")

end
