# dark.cl -- To subtract dark 
# Created: Yoshifusa Ita, 15-Sep-05
# 27-Sep-06 - Add function to account for the dark level change duling a pointing observation (Y. Ita)
# 09-Nov-06 (T.WADA) code reduced. share code in calculation of dark offset.
# 09-Nov-06 (T.WADA) code reduced. use build-in sigma cliping of imstat.
# 09-Nov-06 (T.WADA) avoid floating exception when most of
#             pixel has almost same value (short of NIR).
# 13-Nov-06 (T.WADA) bug fix. not use self dark for short exp frames 
# 15-Nov-06 (T.WADA) use HEADER KEYWORD EXPID to select long exp frames
# 15-Nov-06 (T.WADA) self dark
#                    median=>average
#                    sigclip=>ccdclip (use noise, epadu info from header)
#                    use hthreshold 1000=>INDEF (for MIR-L, of which
#                                                hot pixel is very roud!)
# 05-Feb-07 (T.WADA) masked region dark level analysis$B$KLdBj(B($B$H$/$K(BMIR-L)
#                    lower/upper$B$rBgI}$K9-$2$k(B
#                   ($B$=$l$G$b%@%a$J>l9g$O(BINDEF$B$K$7$F$H$K$+$/B39T(B) 
#                    $B$=$N$+$o$j(Bcliping$B$G30$lCM$r=|5n!"$7$+$b(Bnclip 10=>100
#                    $B$5$i$K(Bmedian$B$G$J$/(Bmode$B$rMxMQ$7$F!"%m%P%9%H$K(B


procedure dark (ircconst, logfile, prefixs, selfdark, deltemp, verbose)
string  mode="al"

string ircconst {"constants.database", prompt="IRC constants database file name"}
string logfile  {"irclog", prompt="output of the mkirclog"}
string prefixs  {"D", prompt="prefix string"}
bool selfdark = no {prompt="Use selfdark instead of Super-Dark?"}
bool deltemp = yes {prompt="Delete intermediate files?"}
bool verbose = no  {prompt="Print verbose progress messages?\n"}

struct *list0

begin

 string libpath
 string irc_const
 string text
 string fname, outname
 string n_short, n_long, s_short, s_long, l_short, l_long
 int expid
 string darkimage
 string prefix
 bool self_dark, verb, deltmp
 string aot, detector, darkver, dver
 string area
 int i, npix, sigrej
 real mean, median, modee, sigma, lower, upper, ll, ul, max, min
 real slitdark, slitsuperdark, darkshift, darkscale
	
 real epadu_s,epadu_l
 real rnoise_s,rnoise_l

 print ("\n")
 print ("### SUBTRACT DARK ###\n")


# get query parameters
 libpath = osfn ("irclib$")
 irc_const = ircconst
 verb = verbose
 self_dark = selfdark
 deltmp = deltemp
 prefix = prefixs
 sigrej = 2.0


# make input file list
 print ("Making the input file list...\n")
 if( access("filename.list") ){ delete("filename.list", ver-) }
 ! cat irclog | perl -e 'while(<>){ chomp; @buf=split(/\s+/,$_); if($buf[0] !~ /\#/){ printf("%s\n",$buf[0])} }' > filename.list


# Read irc constants
 irc_const = libpath//irc_const
 # Dark image for each detector
 printf("! grep darkNIRshort  %s\n", irc_const) | cl | scan(text, n_short)
 printf("! grep darkNIRlong   %s\n", irc_const) | cl | scan(text, n_long)
 printf("! grep darkMIRSshort %s\n", irc_const) | cl | scan(text, s_short)
 printf("! grep darkMIRSlong  %s\n", irc_const) | cl | scan(text, s_long)
 printf("! grep darkMIRLshort %s\n", irc_const) | cl | scan(text, l_short)
 printf("! grep darkMIRLlong  %s\n", irc_const) | cl | scan(text, l_long)
 # Dark version
 printf("! grep darkver       %s\n", irc_const) | cl | scan(text, dver)


# Self dark
 if(self_dark){
	if( !access("darklist.before") ){
		print("cannot read darklist.before\n")
		print("will use super-dark\n")
		goto subtraction
	}
	if( access("dark.mirs") ){ delete("dark.mirs", ver-) }
	if( access("dark.mirl") ){ delete("dark.mirl", ver-) }
	list0 = "darklist.before"
	while( fscan(list0, fname) !=EOF){
	        fname = fname//".fits"
	        hselect(fname, fields="DETECTOR", expr="yes") | scan(detector)
			# 2006/11/15 use long exp frame only for self dark
			hselect(fname, fields="EXPID"   , expr="yes") | scan(expid)
			if(expid !=1){
				if(detector == "MIRS"){
					printf("%s\n", fname, >> "dark.mirs")
					# for ccdcliping... 2006/11/15
					hselect(fname, fields="GAIN"    , expr="yes") | scan(epadu_s)
					hselect(fname, fields="RNOISE"  , expr="yes") | scan(rnoise_s)
			}else if(detector == "MIRL"){
					printf("%s\n", fname, >> "dark.mirl")
					# for ccdcliping... 2006/11/15
					hselect(fname, fields="GAIN"    , expr="yes") | scan(epadu_l)
					hselect(fname, fields="RNOISE"  , expr="yes") | scan(rnoise_l)
				}
			}
	}
	if( access("dark_mirs_long.fits") ){ 
		imdel ("dark_mirs_long.fits", yes, verify=no, default_acti=yes) 
	}
    if( access("dark_mirl_long.fits") ){
		imdel ("dark_mirl_long.fits", yes, verify=no, default_acti=yes) 
	}
	if( access("dark.mirs") ){
## (1)sigclip is not valid for small number of frames
##    N^2 frames must be used for N sigma clipping at least.
##    number of dark in the pointing is small, so 
## (2) dark.mirs/l contains "short frame"! median is not bad idea, but..
## (3) some hot pixels of MIR-L exceed 1000[ADU] in long frame!
## 	   for this reason, combined dark of MIR-L has strange hot pixel
## 	   which has very low top but high wing.
## 	   This make  clear "hot" pixel on dark subtract image and 
##     make troubles in co-adding.
## 			
#		imcombine ("@dark.mirs", "dark_mirs_long.fits", headers="", bpmasks="", rejmasks="", nrejmasks="", expmasks="", sigmas="", logfile="", combine="median", reject="sigclip", project=no, outtype="real", outlimits="", offsets="none", masktype="none", maskvalue=0., blank=0., scale="none", zero="none", weight="none", statsec="", expname="", lthreshold=-200., hthreshold=1000., nlow=1, nhigh=1, nkeep=1, mclip=yes, lsigma=3., hsigma=3., rdnoise="0.", gain="1.", snoise="0.", sigscale=0.1, pclip=-0.5, grow=0.)
        # median=>average, sigclip=>ccdclip, l/h threshold=>INDEF, l/hsigma 2=>sigrej
		imcombine ("@dark.mirs", "dark_mirs_long.fits", headers="", bpmasks="", rejmasks="", nrejmasks="", expmasks="", sigmas="", logfile="", combine="average", reject="ccdclip", project=no, outtype="real", outlimits="", offsets="none", masktype="none", maskvalue=0., blank=0., scale="none", zero="none", weight="none", statsec="", expname="", lthreshold=-200, hthreshold=INDEF, nlow=1, nhigh=1, nkeep=1, mclip=yes, lsigma=sigrej, hsigma=sigrej, rdnoise=rnoise_s, gain=epadu_s, snoise="0.", sigscale=0.1, pclip=-0.5, grow=0.)
		print("\t Made a dark image: dark_mirs_long.fits\n")
	}
	if( access("dark.mirl") ){
#		imcombine ("@dark.mirl", "dark_mirl_long.fits", headers="", bpmasks="", rejmasks="", nrejmasks="", expmasks="", sigmas="", logfile="", combine="median", reject="sigclip", project=no, outtype="real", outlimits="", offsets="none", masktype="none", maskvalue=0., blank=0., scale="none", zero="none", weight="none", statsec="", expname="", lthreshold=-200., hthreshold=1000., nlow=1, nhigh=1, nkeep=1, mclip=yes, lsigma=3., hsigma=3., rdnoise="0.", gain="1.", snoise="0.", sigscale=0.1, pclip=-0.5, grow=0.)
        # median=>average, sigclip=>ccdclip, l/h threshold=>INDEF, l/hsigma 2=>sigrej
		imcombine ("@dark.mirl", "dark_mirl_long.fits", headers="", bpmasks="", rejmasks="", nrejmasks="", expmasks="", sigmas="", logfile="", combine="average", reject="ccdclip", project=no, outtype="real", outlimits="", offsets="none", masktype="none", maskvalue=0., blank=0., scale="none", zero="none", weight="none", statsec="", expname="", lthreshold=-200, hthreshold=INDEF, nlow=1, nhigh=1, nkeep=1, mclip=yes, lsigma=sigrej, hsigma=sigrej, rdnoise=rnoise_l, gain=epadu_l, snoise="0.", sigscale=0.1, pclip=-0.5, grow=0.)
		print("\t Made a dark image: dark_mirl_long.fits\n")
	}
 }

subtraction:
# subtract dark
 print ("Subtracting dark...\n")
 print ("\t #This may take a while...\n")
 list0 = "filename.list"
 while( fscan(list0, fname) !=EOF){
    darkver = dver
    fname = prefix//fname//".fits"
    hselect(fname, fields="AOT", expr="yes")      | scan(aot)
    hselect(fname, fields="EXPID", expr="yes")    | scan(expid)
    hselect(fname, fields="DETECTOR", expr="yes") | scan(detector)
#	printf("debug: %s %d %s\n",aot, expid, detector)
    outname = "D"//fname
    if( access(outname) ){ imdel (outname, yes, verify=no, default_acti=yes) }
	# AOT dependance
	if(aot == "IRC05"){
		text = "dark/aot05/"
	}else{
		text = "dark/"
	}

	# channel dependence	
	if(detector == "NIR"){ # NIR
		if(expid == 1){
			darkimage = libpath//text//n_short
		}else{
			darkimage = libpath//text//n_long
		}
        area = "[1:412,397:512]"
##  2007/02/05 T.WADA
#       lower = -200.0
#	upper =  200.0
			lower = -1000.0
			upper = 10000.0
    }else if(detector == "MIRS"){ # MIRS
		if(expid == 1){
			darkimage = libpath//text//s_short
		}else{
			darkimage = libpath//text//s_long
			if( self_dark ){
				if( access("dark_mirs_long.fits") ){ 
				darkimage = "dark_mirs_long.fits"
				darkver = "SELF"
				}
			}
		}
        	area = "[1:20,1:256]"
##  2007/02/05 T.WADA
#       lower = -200.0
#	upper =  200.0
	        lower = -1000.0
			upper = 10000.0
    }else if(detector == "MIRL"){ # MIRL
		if(expid == 1){
			darkimage = libpath//text//l_short
		}else{
			darkimage = libpath//text//l_long
			if( self_dark ){
				if( access("dark_mirl_long.fits") ){ 
					darkimage = "dark_mirl_long.fits"
					darkver = "SELF"
				}
			}
		}
	        area = "[246:256,82:200]"
##  2007/02/05 T.WADA
#			lower = -200.0
#			upper =  200.0
        	lower = -1000.0
			upper =  10000.0
	}

	## 2007/02/05 T.WADA for debug....
	## for some frame ($B$H$/$K(BMIR-L$B$GGX7J8w$,Hs>o$K6/$$;~(B)$B$G$O(B mask region$B$H$$$($I$b!"(B $B1L$l9~$K$h$j(B+/-200$B$K<}$^$i$J$$>l9g$,$"$k!#!#!#!#!#(B
        ## $B$3$N$?$a!"(Blower-upper$B$N4V$N(Bvalue$B$r;}$D(Bpixel$B$,L5$/$J$j!"(Bimstat$B$G(Bflowting over follow$B$,H/@8$9$k!#(B
	##  ex 3110004.1/rawdata/waF003166247_L002.fits ....
	##
	## $B:,K\E*$K$O!"(B	$BI,;&!V;6Mp8w%+%C%?!<!W$NF3F~$,BT$?$l$k$,!"!"!"!"(B
	##
	## $B$5$F!"$I$&$9$k!)(B
	##  (1) $B$^$:!"(Bmax/min value$B$r5a$a!":GDc8B$A$g$C$H$O0z$C$+$1$k$h$&$K$7$F$*$/$N$,$h$$$N$G$O!)(B 
	##      >>>$B$=$b$=$b$J$<(Blower,upper$B$r@_Dj$9$kI,MW$,M-$C$?$N$@$m$&$+!)(B
	##  (2) $B$$$C$=$N$3$H(BINDEF$B$K$7$F$7$^$*$&$+(B? 
	##  (3) $B$H$j$"$($:(Blower/upper$B$O8=<BE*$JCM(B (MIR-L$B$K$D$$$F$O(B 200=>-1000?+10000)$B$K(B
	##  (4) max/min$B$KF~$C$F$$$J$+$C$?$i!"(Bwarning$B$r=P$7$D$D!"(B lower/upper$B$r(BINDEF$B$K$7=hM}$OB3$1$k(B
	##  (5) median(midpt)$B$h$j(Bmode$B$NJ}$,%m%P%9%H$C$]$$!#!#!#!#(B
	##  (6) cliping$B$GCF$1$k$N$G$O!)(B
    ##		(3)+(4)+(5)+(6)
	if(verb){
			imstat(fname//area, \
					fields="npix,mean,midpt,mode,stddev,min,max", lower=INDEF, upper=INDEF,lsigma=sigrej,usigma=sigrej, nclip=0, binwidth=0.1, 
			format=no, cache=no) | scan(npix, mean, median, modee, sigma, min, max)
#			printf("debug: %s %s %f %f %f %f %f\n",fname,area,lower,upper,sigrej, min,max)
			printf("debug: %s %s %g %g %g %g %g\n",fname,area,lower,upper,sigrej, min,max)
	}

	imstat(fname//area, fields="npix", lower=lower, upper=upper, format=no, cache=no) | scan(npix)
	if ( npix <= 100){  # imstat$B$K$h$k(Bfloating exception$B$rKI;_$9$k!#(B
		lower = INDEF
		upper = INDEF
		printf("warning: too few number of pixels %d are found in masked region of %s\n",npix,fname//area)
		printf("warning: set lower/upper to INDEF\n")
	}

	# estimate dark level at masked region of "target frame"
#	imstat(fname//area, fields="npix,mean,midpt,mode,stddev", lower=lower, upper=upper,lsigma=sigrej,usigma=sigrej, nclip=10, binwidth=0.1, format=no, cache=no) | scan(npix, mean, median, modee, sigma)			
	imstat(fname//area, fields="npix,mean,midpt,mode,stddev", lower=lower, upper=upper,lsigma=sigrej,usigma=sigrej, nclip=100, binwidth=0.1, format=no, cache=no) | scan(npix, mean, median, modee, sigma)			
	if(verb){
			printf("debug: %s %s %g %g %g %g %g\n",fname,area,npix,mean,median,modee,sigma)
	}
		
		
#	if(median != INDEF)	{
#   	slitdark = median
# median$B$,7W;;=PMh$J$$$N$O!"$*$=$i$/A4$F$N(Bpixel$B$,(Breject$B$5$l$F!";D$i$J$+$C$?$+$i!#(B
# $B$=$l$O!"$9$Y$F$N(Bpixel$B$NCM$,F1$8$P$"$$$K5/$-$k(B($B$H$/$K(BNIR$B$N(Bshort$B$O!"$b$H$b$H(Bdark$B$,6K>.$J$&$(!"(Bbitshift$B$K$h$j(B1/4, 1/16$B$K$J$C$F$$$k$?$aNL;R2=OD$K$h$j(Ball zero$B$K$J$j$,$A(B)
	if(modee != INDEF)	{
		slitdark = modee
	}else{ 	

		slitdark = mean
	}
	hedit (fname, "DARKVER", "v"//darkver, add=no, addonly=yes, delete=no, verify=no, show=no, update=yes)

	# estimate dark level at masked region of "dark frame"
#	lower = -200.0
#	upper =  200.0
	lower = -1000.0
	upper = 10000.0
	imstat(darkimage//area, fields="npix", lower=lower, upper=upper, format=no, cache=no) | scan(npix)
	if ( npix <= 100){  # imstat$B$K$h$k(Bfloating exception$B$rKI;_$9$k!#(B
		lower = INDEF
		upper = INDEF
		printf("warning: too few number of pixels %d are found in masked region of %s\n",npix,darkimage//area)
		printf("warning: set lower/upper to INDEF\n")
	}
#	imstat(darkimage//area, fields="npix,mean,midpt,mode,stddev", lower=lower, upper=upper,lsigma=sigrej,usigma=sigrej, nclip=10, binwidth=0.1, format=no, cache=no) | scan(npix, mean, median, modee, sigma)			
	imstat(darkimage//area, fields="npix,mean,midpt,mode,stddev", lower=lower, upper=upper,lsigma=sigrej,usigma=sigrej, nclip=100, binwidth=0.1, format=no, cache=no) | scan(npix, mean, median, modee, sigma)			
			
	if(verb){
			printf("debug: %s %s %g %g %g %g %g\n",darkimage,area,npix,mean,median,modee,sigma)
	}
			
#	if(median != INDEF)	{
#		slitsuperdark = median
	if(modee != INDEF)	{
		slitsuperdark = modee
	}else{
		slitsuperdark = mean
	}

	# 1pointing$BCf$K(Bdark level$B$,JQF0$9$k>l9g$r9MN8$7$F!"$2$?NL$r$b$H$a$F!"$=$l$r$R$/!#(B
	darkshift = slitdark - slitsuperdark
	if(slitsuperdark !=0){
		darkscale = slitdark/slitsuperdark
	}else{
		darkscale = INDEF
	}

	if(verb){
		printf("dark.cl: %s tmp:%f sup:%f t-s:%f t/s:%f\n",fname, slitdark, slitsuperdark, darkshift, darkscale)
	}

	# dark subtraction
	imarith (fname,   "-", darkimage, outname, title="", divzero=0., hparams="", pixtype="real", calctype="double", verbose=verb, noact=no)
	# offset correction using masked area value
	imarith (outname, "-", darkshift, outname, title="", divzero=0., hparams="", pixtype="real", calctype="double", verbose=verb, noact=no)
	ccdhedit (outname, paramete="DRKSHIFT", value=darkshift,     type="real")
	ccdhedit (outname, paramete="DRKAREA",  value=area,          type="string")
	ccdhedit (outname, paramete="DRKEST",   value=slitdark,      type="real")
	ccdhedit (outname, paramete="DRKESTRF", value=slitsuperdark, type="real")
		
	# scale
#        if( access("scaledark.fits") ){ imdel ("scaledark.fits", yes, verify=no, default_acti=yes) }
#        imarith (darkimage, "*", darkscale, "scaledark.fits", title="", divzero=0., hparams="", pixtype="real", calctype="double", verbose=verb, noact=no)
#        imarith (fname,     "-", "scaledark.fits",   outname, title="", divzero=0., hparams="", pixtype="real", calctype="double", verbose=verb, noact=no)
#        if( access("scaledark.fits") ){ imdel ("scaledark.fits", yes, verify=no, default_acti=yes) }

#	printf("debug: %s %s\n", darkimage, darkver)
        if (deltmp) imdel(fname, yes, verify=no, default_acti=yes)
 }


# cleaning
 if( access("filename.list") ){ delete("filename.list", ver-) }

 print ("### SUBTRACT DARK finished!! ###\n")

end

