# flat.cl -- To correct the IRC flat
# Created: Yoshifusa Ita, 29-Aug-05
# Updated: Yoshifusa Ita, 13-Jun-07 select soramame-ari/nashi according to observing dates.
# Updated: Yoshifusa Ita, 13-Jun-07 users can use their own flat images

procedure flat (ircconst, logfile, prefixs, defaultflat, deltemp, verbose)
string  mode="al"

string ircconst  {"constants.database", prompt="IRC constants database file name"}
string logfile   {"irclog", prompt="output of the mkirclog"}
string prefixs   {"f", prompt="prefix string"}
bool   defaultflat = yes {prompt="Use pipeline's default flat?"}
bool   deltemp = yes     {prompt="Delete intermediate files?"}
bool   verbose = no      {prompt="Print verbose progress messages?\n"}

struct *list0
struct *list1

begin

 string libpath
 string irc_const
 string fname, outname
 string filter, flatfile
 string n2flat, n3flat, n4flat
 string s7flat, s9wflat, s11flat
 string l15flat, l18wflat, l24flat
 string prefix
 string flatver
 bool def_flat, verb, deltmp
 int status, date
 string path

 print ("\n")
 print ("### FLAT FIELDING ###\n")

# get query parameters
 libpath = osfn ("irclib$")
 irc_const = ircconst
 def_flat = defaultflat
 verb = verbose
 deltmp = deltemp
 prefix = prefixs


# make input file list
 print ("Making the input file list...\n")
 if( access("filename.list") ){ delete("filename.list", ver-) }
 ! cat irclog | perl -e 'while(<>){ chomp; @buf=split(/\s+/,$_); if($buf[0] !~ /\#/){ printf("%s\n",$buf[0])} }' > filename.list


# Read irc constants
 irc_const = libpath//irc_const
 # Flat version
 printf("! grep flatver  %s\n", irc_const) | cl | scan(text, flatver)
 # Flat field image for each filter
 printf("! grep N2flat   %s\n", irc_const) | cl | scan(text, n2flat)
 printf("! grep N3flat   %s\n", irc_const) | cl | scan(text, n3flat)
 printf("! grep N4flat   %s\n", irc_const) | cl | scan(text, n4flat)
 printf("! grep S7flat   %s\n", irc_const) | cl | scan(text, s7flat)
 printf("! grep S9Wflat  %s\n", irc_const) | cl | scan(text, s9wflat)
 printf("! grep S11flat  %s\n", irc_const) | cl | scan(text, s11flat)
 printf("! grep L15flat  %s\n", irc_const) | cl | scan(text, l15flat)
 printf("! grep L18Wflat %s\n", irc_const) | cl | scan(text, l18wflat)
 printf("! grep L24flat  %s\n", irc_const) | cl | scan(text, l24flat)


# Flat fielding
 print ("Flat fielding...\n")
 print ("\t #This may take a while...\n")
 list0 = "filename.list"
 while( fscan(list0, fname) !=EOF){
        fname = prefix//fname//".fits"
        hselect(fname, fields="FILTER", expr="yes") | scan(filter)
	if( access("obsdate.dat") ){ delete("obsdate.dat", ver-) }
        hselect(fname, fields="DATE-REF", expr="yes", > "obsdate.dat")
	# $B4QB,F|$r@0?t$K$9$k!#(B
	if( access("tmp.dat") ){ delete("tmp.dat", ver-) }
        ! cat obsdate.dat | tr 'T' ' ' | awk '{print $1}' | tr '-' '0' > tmp.dat
	date = 0
	list1 = "tmp.dat"
	status = fscan(list1, date)
	if(def_flat){
		if(date > 2007001008){
			path = "soramame-nashi/"
		}else{
			path = "soramame-ari/"
		}
		hedit (fname, "FLATVER", "v"//flatver, add=no, addonly=yes, delete=no, verify=no, show=no, update=yes)
	}else{
		path = "user/"
		hedit (fname, "FLATVER", "user", add=no, addonly=yes, delete=no, verify=no, show=no, update=yes)
	}
	outname = "f"//fname
	if( access(outname) ){ imdel (outname, yes, verify=no, default_acti=yes) }
        if(filter=="N2"){
                flatfile = libpath//"flat/"//path//n2flat
        }else if(filter=="N3"){
                flatfile = libpath//"flat/"//path//n3flat
        }else if(filter=="N4"){
                flatfile = libpath//"flat/"//path//n4flat
        }else if(filter=="S7"){
                flatfile = libpath//"flat/"//path//s7flat
        }else if(filter=="S9W"){
                flatfile = libpath//"flat/"//path//s9wflat
        }else if(filter=="S11"){
                flatfile = libpath//"flat/"//path//s11flat
        }else if(filter=="L15"){
                flatfile = libpath//"flat/"//path//l15flat
        }else if(filter=="L18W"){
                flatfile = libpath//"flat/"//path//l18wflat
        }else if(filter=="L24"){
                flatfile = libpath//"flat/"//path//l24flat
        }
        imarith(fname, "/", flatfile, outname, title="", divzero=-9999.9, hparams="", pixtype="real", calctype="double", verbose=verb, noact=no)
        if (deltmp) imdel(fname, yes, verify=no, default_acti=yes)
 }


# cleaning
 if( access("temp.list") ){ delete("temp.list", ver-) }
 if( access("obsdate.dat") ){ delete("obsdate.dat", ver-) }
 if( access("tmp.dat") ){ delete("tmp.dat", ver-) }

 print ("### FLAT FIELDING finished!! ###\n")

end
