# ircnorm.cl -- To renormalize fowler sampling/ bitshift
# Created: Yoshifusa Ita, 02-Jul-06

procedure ircnorm (ircconst, logfile, prefixs, deltemp, verbose)
string  mode="al"

string ircconst {"constants.database", prompt="IRC constants database file name"}
string logfile  {"irclog", prompt="output of the mkirclog"}
string prefixs  {"a", prompt="prefix string"}
bool   deltemp = yes {prompt="Delete intermediate files?"}
bool   verbose = no {prompt="Print verbose progress messages?"}
struct *list0

begin

 string fname, outname, libpath, irc_const
 string aot, detector
 string prefix
 int expid
 bool verb, deltmp

 print ("\n")
 print ("### IRCNORM ###\n")

# get query parameters
 libpath = osfn ("irclib$")
 irc_const = ircconst
 prefix = prefixs
 verb = verbose
 deltmp = deltemp


# make input file list
 print ("Making the input file list...\n")
 if( access("filename.list") ){ delete("filename.list", ver-) }
 ! cat irclog | perl -e 'while(<>){ chomp; @buf=split(/\s+/,$_); if($buf[0] !~ /\#/){ printf("%s\n",$buf[0])} }' > filename.list


# Renormalization
 print ("Fowler sampling/bit shift renormalization...\n")
 print ("\t #This may take a while...\n")
 list0 = "filename.list"
 while( fscan(list0, fname) !=EOF){
	fname = prefix//fname//".fits"
        hselect(fname, fields="AOT", expr="yes")      | scan(aot)
        hselect(fname, fields="EXPID", expr="yes")    | scan(expid)
        hselect(fname, fields="DETECTOR", expr="yes") | scan(detector)
	outname = "n"//fname
	if( access(outname) ){ imdel (outname, yes, verify=no, default_acti=yes) }
	if(detector == "NIR"){ # NIR
		if(expid == 1){ # short frame$B$J$i(B
			if(aot == "IRC05"){ # aot$B$,(B05$B$@$C$?$i(B
				imarith (fname, "*", 4.0, outname, title="", divzero=0., hparams="", pixtype="real", calctype="double", verbose=verb, noact=no)
			}else{ # $B$=$l0J30$O$=$N$^$^%3%T!<(B
				imcopy (fname, outname, verbose=verb)
			}
		}else{ # long frame$B$J$i(B
			imarith (fname, "/", 4.0, outname, title="", divzero=0., hparams="", pixtype="real", calctype="double", verbose=verb, noact=no)
		}
	}else{ # MIR
		if(expid == 1){ # short frame$B$J$i(B
			imarith (fname, "*", 4.0, outname, title="", divzero=0., hparams="", pixtype="real", calctype="double", verbose=verb, noact=no)
		}else{ # long frame$B$O$=$N$^$^%3%T!<(B
			imcopy (fname, outname, verbose=verb)
		}
	}
        if (deltmp) imdel(fname, yes, verify=no, default_acti=yes)
 }

# cleaning
 if( access("filename.list") ){ delete("filename.list", ver-) }

 print ("### IRCNORM finished!! ###\n")

end
