# saturation.cl -- To mask saturated pixels
# Created: Yoshifusa Ita, 14-Sep-05
# Upgrade: Yoshifusa Ita, 06-Jun-06

procedure saturation (ircconst, logfile, prefixs, deltemp, verbose)
string  mode="al"

string ircconst {"constants.database", prompt="IRC constants database file name"}
string logfile  {"irclog", prompt="Output of the mkirclog"}
string prefixs  {"s", prompt="prefix string"}
bool   deltemp = yes {prompt="Delete intermediate files?"}
bool   verbose = no {prompt="Print verbose progress messages?\n"}
struct *list0

begin

 string irc_const, libpath, exprname, aot, detector
 string fname, refname, outname, rootname
 real n_fullwell, s_fullwell, l_fullwell
 real n_shrt, n_long, n_aot05, n_aot0c, m_shrt, m_long
 real n_thresh, s_thresh, l_thresh, n_aot05_th, n_aot0c_th
 int expid, status
 string prefix
 bool verb, deltmp

 print ("\n")
 print ("### SATURATION ###\n")

# get query parameters
 libpath = osfn ("irclib$")
 irc_const = ircconst
 prefix = prefixs
 deltmp = deltemp
 verb = verbose


# make input file list
 print ("Making the input file list...\n")
 if( access("filename.list") ){ delete("filename.list", ver-) }
 ! cat irclog | perl -e 'while(<>){ chomp; @buf=split(/\s+/,$_); if($buf[0] !~ /\#/){ printf("%s\n",$buf[0])} }' > tmp.list
 ! sed 's/...$//' tmp.list > tmp2.list
 ! paste -d " " tmp.list tmp2.list > filename.list
 if( access("tmp.list") ){ delete("tmp.list", ver-) }
 if( access("tmp2.list") ){ delete("tmp2.list", ver-) }


# Read irc constants
 irc_const = libpath//irc_const
 # full well [ADU]
 printf("! grep fullwell_nir   %s\n", irc_const) | cl | scan(text, n_fullwell)
 printf("! grep fullwell_mirs  %s\n", irc_const) | cl | scan(text, s_fullwell)
 printf("! grep fullwell_mirl  %s\n", irc_const) | cl | scan(text, l_fullwell)
 # exposure time [sec]
 printf("! grep nir_short      %s\n", irc_const) | cl | scan(text, n_shrt)
 printf("! grep nir_long       %s\n", irc_const) | cl | scan(text, n_long)
 printf("! grep nir_aot05_long %s\n", irc_const) | cl | scan(text, n_aot05)
 printf("! grep nir_aot0c_long %s\n", irc_const) | cl | scan(text, n_aot0c)
 printf("! grep mir_short      %s\n", irc_const) | cl | scan(text, m_shrt)
 printf("! grep mir_long       %s\n", irc_const) | cl | scan(text, m_long)
 # threshold for saturation
 n_thresh   = n_fullwell * n_shrt / n_long  # ircnorm$B$,=*$o$C$?$N$G!"@QJ,;~4VHf$G%9%1!<%k!#(B
 n_aot05_th = n_fullwell * n_shrt / n_aot05
 n_aot0c_th = n_fullwell * n_shrt / n_aot0c
 s_thresh   = s_fullwell * m_shrt / m_long 
 l_thresh   = l_fullwell * m_shrt / m_long 
 if( access("nir.expr")   ){ delete("nir.expr", ver-)   }
 if( access("aot05.expr") ){ delete("aot05.expr", ver-) }
 if( access("aot0c.expr") ){ delete("aot0c.expr", ver-) }
 if( access("nir.expr")   ){ delete("nir.expr", ver-)   }
 if( access("mirs.expr")  ){ delete("mirs.expr", ver-)  }
 if( access("mirl.expr")  ){ delete("mirl.expr", ver-)  }
 printf("(I > 4)&&(a > %f) ? (b*0.0) : b\n", n_thresh,   > "nir.expr" )
 printf("(I > 4)&&(a > %f) ? (b*0.0) : b\n", n_aot05_th, > "aot05.expr" )
 printf("(I > 4)&&(a > %f) ? (b*0.0) : b\n", n_aot0c_th, > "aot0c.expr" )
 printf("(I > 4)&&(a > %f) ? (b*0.0) : b\n", s_thresh,   > "mirs.expr")
 printf("(I > 4)&&(a > %f) ? (b*0.0) : b\n", l_thresh,   > "mirl.expr")


# Correction
 print ("Masking saturated pixels...\n")
 print ("\t #This may take a while...\n")
 list0 = "filename.list"
 while( fscan(list0, fname, rootname) !=EOF){
	fname    = prefix//fname
	rootname = prefix//rootname
        hselect(fname, fields="AOT",      expr="yes") | scan(aot)
        hselect(fname, fields="EXPID",    expr="yes") | scan(expid)
        hselect(fname, fields="DETECTOR", expr="yes") | scan(detector)
	if(detector == "NIR"){ # NIR
		if(expid == 1){ # short frame -> just rename
		        outname = "s"//fname//".fits"
			if( access(outname) ){ imdel (outname, yes, verify=no, default_acti=yes) }
			imrename (fname//".fits", outname, verbose=no)
		}else{ # long exposure frame
			refname = "s"//rootname//"001.fits"
			outname = "s"//rootname//"00"//expid//".fits"
			if( access(outname) ){ imdel (outname, yes, verify=no, default_acti=yes) }
			if(aot == "IRC05"){
				exprname = "aot05.expr"
			}else if(aot == "IRC0C"){
				exprname = "aot0c.expr"
			}else{
				exprname = "nir.expr"
			}
			if( access(refname) ){
				imexpr ("@"//exprname, outname, refname, fname//".fits", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", dims="auto", intype="double", outtype="real", refim="b", bwidth=0, btype="constant", bpixval=0., rangecheck=yes, verbose=no, exprdb="none", lastout=outname)
			}else{
				printf("No reference short image for %s. Just rename as %s.\n", fname//".fits", outname)
				imrename (fname//".fits", outname, verbose=no)
			}
		}
	}else{ # MIR
		if(detector == "MIRS"){
			exprname = "mirs.expr"
		}else if(detector == "MIRL"){
			exprname = "mirl.expr"
		}
		if(expid == 1){ # short frame -> just rename
		        outname = "s"//fname//".fits"
			if( access(outname) ){ imdel (outname, yes, verify=no, default_acti=yes) }
			imrename (fname//".fits", outname, verbose=no)
		}else{ # long exposure frame
			refname = "s"//rootname//"001.fits"
			outname = "s"//rootname//"00"//expid//".fits"
			if( access(outname) ){ imdel (outname, yes, verify=no, default_acti=yes) }
			if( access(refname) ){
				imexpr ("@"//exprname, outname, refname, fname//".fits", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", dims="auto", intype="double", outtype="real", refim="b", bwidth=0, btype="constant", bpixval=0., rangecheck=yes, verbose=no, exprdb="none", lastout=outname)
			}else{
				printf("No reference short image for %s. Just rename as %s.\n", fname//".fits", outname)
				imrename (fname//".fits", outname, verbose=no)
			}
		}
	}
	if(deltmp){
		if( access(fname//".fits") ){ imdel (fname//".fits", yes, verify=no, default_acti=yes) }
	}
 }


## cleaning
 if( access("filename.list") ){ delete("filename.list", ver-) }
 if( access("nir.expr")      ){ delete("nir.expr", ver-)      }
 if( access("aot05.expr")    ){ delete("aot05.expr", ver-)    }
 if( access("aot0c.expr")    ){ delete("aot0c.expr", ver-)    }
 if( access("mirs.expr")     ){ delete("mirs.expr", ver-)     }
 if( access("mirl.expr")     ){ delete("mirl.expr", ver-)     }

 print ("### SATURATION finished!! ###\n")

end
