# slit_mask.cl -- To mask the slit region
# Created: Yoshifusa Ita, 10-Apr-06

procedure slit_mask(ircconst, logfile, prefixs, deltemp, verbose)
string  mode="al"

string ircconst {"constants.database", prompt="IRC constants database file name"}
string logfile  {"irclog", prompt="output of the mkirclog"}
string prefixs  {"a", prompt="prefix string"}
bool   deltemp = yes {prompt="Delete intermediate files?"}
bool   verbose = no {prompt="Print verbose progress messages?"}
struct *list0

begin

 string fname, outname
 string libpath
 string irc_const
 string maskfile, nmask, smask, lmask
 string prefix
 string detector
 bool verb, deltmp

 print ("\n")
 print ("### SLIT_MASK ###\n")

# get query parameters
 libpath = osfn ("irclib$")
 irc_const = ircconst
 verb = verbose
 deltmp = deltemp
 prefix = prefixs


# make input file list
 print ("Making the input file list...\n")
 if( access("filename.list") ){ delete("filename.list", ver-) }
 ! cat irclog | perl -e 'while(<>){ chomp; @buf=split(/\s+/,$_); if($buf[0] !~ /\#/){ printf("%s\n",$buf[0])} }' > filename.list


# Read irc constants
 irc_const = libpath//irc_const
 # File name
 printf("! grep slit_mask_nir  %s\n", irc_const) | cl | scan(text, nmask)
 printf("! grep slit_mask_mirs %s\n", irc_const) | cl | scan(text, smask)
 printf("! grep slit_mask_mirl %s\n", irc_const) | cl | scan(text, lmask)


# Masking
 print ("Masking the anomalous pixels...\n")
 print ("\t #This may take a while...\n")
 list0 = "filename.list"
 while( fscan(list0, fname) !=EOF){
	fname = prefix//fname//".fits"
        hselect(fname, fields="DETECTOR", expr="yes") | scan(detector)
	outname = "m"//fname
        if( access(outname) ){ imdel (outname, yes, verify=no, default_acti=yes) }
	if(detector == "NIR"){ # NIR
		maskfile = libpath//"slit_mask/"//nmask
        }else if(detector == "MIRS"){ # MIRS
		maskfile = libpath//"slit_mask/"//smask
        }else if(detector == "MIRL"){ # MIRL
		maskfile = libpath//"slit_mask/"//lmask
	}
 	imarith (fname, "+", maskfile, outname, title="", divzero=0., hparams="", pixtype="real", calctype="double", verbose=verb, noact=no)
	if (deltmp) imdel(fname, yes, verify=no, default_acti=yes)
 }

# cleaning
 if( access("filename.list") ){ delete("filename.list", ver-) }

 print ("### SLIT_MASK finished!! ###\n")

end
