# coaddLusingS.cl -- To coadd L images with few stars by using S shift value
# Created: Yoshifusa Ita, 20-Jun-06

procedure coaddLusingS (s_list, com_mode, com_area, sky_area, logfile, verbose)
string  mode="al"

string ircconst     {"constants.database", prompt="IRC constants database file name"}
string s_list       {"pair0004_S11.list_long", prompt="Name of shift reference list"}
string com_mode     {"median", prompt="combine mode: average/median"}
int    com_area     {2,min=1,max=2, prompt="stack area: 1:common area 2:whole area"}
int    sky_area     {1,min=1,max=2, prompt="sky matching area: 1:common area 2:whole area"}
string rejection    {"sigclip", prompt="rej in coadd:minmax|ccdclip|crreject|sigclip|avsigclip|pclip|none"}
string logfile      {"irclog", prompt="Output of the mkirclog"}
real   sig_rej      {3.,min=0.,max=100., prompt="Number of sigmas for imstat limits"}
int    max_itr      {10,min=1,max=10, prompt="Maximum number of iterations"}
string prefixs      {"SfdmslnDwa", prompt="prefix string"}
bool   wcs = no     {prompt="Try to compute wcs and write it in the header?"}
bool   rej_sky = yes {prompt="Remove image(s) with outlier sky level?"}
bool   submedsky = no {prompt="Subtract median filtered sky in adjust_sky?"}
bool   verbose = no {prompt="Print verbose progress messages?\n"}
struct *list0

begin

 string irc_const, slist, llist, rejtype, text, filter
 string commode, prefix, libpath, pcommand
 int    i, maxitr, comarea, skyarea, expid, long_short
 bool   verb, rejsky, setwcs, sub_medsky
 string sname, ssub, shiftdata, slink, input, output
 int smatched
 real   sigrej, bad_const

 print ("### COADD L using S ###\n")

# Get query parameters
 irc_const = ircconst
 slist = s_list
 commode = com_mode
 comarea = com_area
 skyarea = sky_area
 prefix = prefixs
 sigrej = sig_rej
 maxitr = max_itr
 rejtype = rejection
 setwcs = wcs
 rejsky = rej_sky
 verb = verbose
 sub_medsky = submedsky


# llist
 llist = slist//"_forL"


# Read irc constants
 libpath = osfn("irclib$")
 irc_const = libpath//irc_const
 printf("! grep baddata %s\n", irc_const) | cl | scan(text, bad_const)


# S$B$N%j%9%H$r$h$s$G!"%j%9%H$r$D$/$k!#(B
 if( access("reference_S.list") ){ delete("reference_S.list", ver-) }
 pcommand = osfn ("ircperl$")
 pcommand = pcommand//"coaddLusingS.pl"
 printf("! %s %s.shift > reference_S.list \n", pcommand, slist) | cl


# $B%j%9%H$rFI$_9~$s$GH/F0(B
 print ("### Shift and Rotate L images ###\n")
 if( access(llist) ){ delete(llist, ver-) }
 if( access(llist//".shift") ){ delete(llist//".shift", ver-) }
 i = 0
 list0 = "reference_S.list"
 while (fscan (list0, sname, ssub, smatched) != EOF) {
	if(smatched > 1){ # $B%^%C%A$7$F$$$?$i(B
		input  = sname//"_L"//ssub
		output = "R"//input//".fits"
		if( access(output) ){ imdel(output, ver-) }
		shiftdata = sname//"_S"//ssub//".fits.shift"
		slink     = sname//"_L"//ssub//".fits.shift"
		if( access(slink) ){ delete(slink, ver-) }
		if(i==0){ # $B0LCV$N4p=`%U%l!<%`$N>l9g!"$=$N$^$^%3%T!<(B
			imcopy(input//".fits", output, verbose=no)
			hselect(output, fields="FILTER", expr="yes") | scan(filter)
			hselect(output, fields="EXPID", expr="yes") | scan(expid)
		}else{ # $B$=$l0J30$N>l9g$O!"(BS$B$N%7%U%H>pJs$r$b$H$K!"%7%U%H$7$F$7$^$&!#(B
			geotran(input//".fits", output, shiftdata, "record.dat", geometry="linear", xin=INDEF, yin=INDEF, xshift=INDEF, yshift=INDEF, xout=INDEF, yout=INDEF, xmag=INDEF, ymag=INDEF, xrotation=INDEF, yrotation=INDEF, xmin=INDEF, xmax=INDEF, ymin=INDEF, ymax=INDEF, xscale=1.0, yscale=1.0, ncols=INDEF, nlines=INDEF, xsample=1., ysample=1., interpolant="linear", boundary="constant", constant=-99999, fluxconserve=yes, nxblock=2048, nyblock=2048, verbose=verb)
			printf("! ln -s %s %s\n", shiftdata, slink) | cl
		}
		printf("%s_L%s %s\n", sname, ssub, filter, >> llist)
		printf("%s.fits.coo.1 0 0 0 999\n", input, >> llist//".shift")
	}
	i += 1
 }


# long$B$+(Bshort$B$+!)(B
 if(expid==1){
	long_short = 1
 }else{
	long_short = 0
 }


# $B%9%+%$9g$o$;(B
 print ("### Adjusting Sky ###\n")
 adjust_sky(prefixs=prefix, badconst=bad_const, list_name=llist, sky_area=skyarea, data_max=50000, sig_rej=sigrej, max_itr=maxitr, rej_sky=rejsky, submedsky=sub_medsky, verbose=verb)


# coadd$B=`Hw(B
 if( access("l.input") ){ delete("l.input", ver-) }
 printf("%s\n", llist, > "l.input" )
 if( !access("stacked_IM") ){ print("! mkdir stacked_IM\n") | cl }


# coadding images
 printf ("### Coadding %s images ###\n", filter)
 if( access("coadd.failure") ){ delete("coadd.failure", ver-) }
 irc_stack(list_name="l.input",  prefixs="", lng_shrt=long_short, badconst=bad_const, sig_rej=sigrej, com_mode=commode, com_area=comarea, rejection=rejtype, rej_sky=rejsky, wcs=setwcs, verbose=verb)


## cleaning
 if( access("reference_S.list") ){ delete("reference_S.list", ver-) }
 if( access("l.input") ){ delete("l.input", ver-) }


# move files
 ! \mv sigma*.fits stacked_IM
 ! \mv pl*.pl stacked_IM
 if( ! access("logs") ){ print("! mkdir logs\n") | cl }
 ! \mv skypair* logs

end
