# ircslice.cl -- To slice the IRC 3D images into the 2D ones.
# Created: Yoshifusa Ita, 02-Jul-05
# 05-Jul-05 - Add cleaning (Y. Ita)
# Updated: Yoshifusa Ita, 25-Aug-06, Add header keyword - GAIN and SUBID
# Updated: Yoshifusa Ita, 05-Nov-06, Add header keyword - C(R)PIX1 and C(R)PIX2
# Updated: Takehiko Wada  07-Jan-03, enable to update DETECTOR
#                                    KEYWORD (for MIR)
# Updated: Takehiko Wada  2007/01/03 
#           update HEADER (replace non-alphabet, decimal to "_")
#           $B$&$C$H$&$7$$$N$G!"(Bslice$B8e$N(Bheader$B$K$O!"(BOBJECT$BL>$N1Q?t;z0J(B
#          $B30$NJ8;z$rA4It(B "_"$B$KF~$l49$($^$9!#(B

procedure ircslice (ircconst, verbose)
string  mode="al"

string  ircconst     {"constants.database", prompt="IRC constants database file name"}
bool    verbose = no {prompt="Print verbose progress messages?\n"}
struct *list0

begin

 string irc_const, libpath
 string fname, finput, foutput, sname, lname
 string tmp1, tmp2, text
 string pipever
 int 	naxis, naxis1, naxis2, naxis3
 bool   verb
 real   epadu_nir, epadu_mirs, epadu_mirl
 string object_name	

 print ("### IRCSLICE ###\n")

# get querty parameters
 verb = verbose
 irc_const = ircconst


# edit header
 libpath = osfn ("irclib$")
 irc_const = libpath//irc_const
 # pipeline version
 printf("! grep pipever        %s\n", irc_const) | cl | scan(text, pipever)
 # A2D unit (Gain) [electrons/ADU]
 printf("! grep epadu_nir      %s\n", irc_const) | cl | scan(text, epadu_nir)
 printf("! grep epadu_mirs     %s\n", irc_const) | cl | scan(text, epadu_mirs)
 printf("! grep epadu_mirl     %s\n", irc_const) | cl | scan(text, epadu_mirl)


# make input file list
 if( access("filename.list") ){ delete("filename.list", ver-) }
 print ("Making the input file list...\n")
 ! ls -1 ../rawdata | egrep -e F\*.fits > filename.list


# check the dimension of the fits file
 print ("Checking the dimension of the input files...\n")
 if( access("slice_tmp0") ){ delete("slice_tmp0", ver-) }
 list0 = "filename.list"
 while( fscan(list0, fname) !=EOF){
       fname="../rawdata/"//fname
#       hselect(fname, fields="$I,NAXIS,NAXIS1,NAXIS2,NAXIS3", expr="yes", >> "slice_tmp0")
		hselect(fname, fields="$I,NAXIS,NAXIS1,NAXIS2,NAXIS3,OBJECT", expr="yes", >> "slice_tmp0")
 }

# slice and imcopy
 print ("Slicing images...\n")
 print ("\t #This may take a while...\n")
# ! cat slice_tmp0 | perl -e 'while(<>){ chomp; @buf1=split(/\s+/,$_); @buf2=split(/\//,$buf1[0]); @buf3=split(/\./,$buf2[2]); @buf4=split(/_/,$buf3[0]); printf("%s %d %d %d %d\n",$buf4[0],$buf1[1],$buf1[2],$buf1[3],$buf1[4]) }' > output.list
# output.list$B$N%U%)!<%^%C%H$O!"(B"FXXXXXXXXX" naxis naxis1 naxis2 naxis3 object_name
# $B$?$@$7(Bobject_name$B$O!"$"$H$G6uGr6h@Z$j$K$h$k<h$j07$$$r2DG=$K$9$k$?$a!"(B
# $B1Q?t;z0J30$r(B"_"$B$KJQ49$7$F$*$/(B
! cat slice_tmp0 | perl -e 'while(<>){ chomp; split(/\t/);$_[0]=~s/.*F([0-9]+)_.*/F$1/;$_[5]=~s/\"//g;$_[5]=~s/\W/_/g;printf("%s %d %d %d %d %s\n",$_[0],$_[1],$_[2],$_[3],$_[4],$_[5]) }' > output.list
 list0 = "output.list"
 while( fscan(list0, fname, naxis, naxis1, naxis2, naxis3, object_name) !=EOF ){
	if(naxis1==412){ # NIR
		finput  = "../rawdata/"//fname//"_N.fits"
		foutput = fname//"_N"
 		imcopy (finput, foutput, verbose=verb)
		# OBJECT$BL>$r(Bupdate$B$7$F$*$/(B
		hedit (foutput, "OBJECT", object_name, add=yes, addonly=no, delete=no, verify=no, show=no, update=yes)
		# Pipeline version
		hedit (foutput, "PIPEVER", "v"//pipever, add=no, addonly=yes, delete=no, verify=no, show=no, update=yes)
		# Detector
		hedit (foutput, "DETECTOR", "NIR",  add=yes, addonly=no, delete=no, verify=no, show=no, update=yes)
		# GAIN [e/adu]
		ccdhedit (foutput, paramete="GAIN", value=epadu_nir, type="real")
		# CPIX1 & CPIX2
#		ccdhedit (foutput, paramete="CPIX1", value=206.0, type="real")
		ccdhedit (foutput, paramete="CPIX1", value=197.0, type="real")
		ccdhedit (foutput, paramete="CPIX2", value=191.0, type="real")
		# $B%9%i%$%9$9$k!#(B
		finput = foutput
 		imslice(finput, foutput, 3, verbose=verb)
		# EXPID [1:short 2:long]
		ccdhedit (foutput//"001.fits", paramete="EXPID", value=1, type="integer")
		ccdhedit (foutput//"002.fits", paramete="EXPID", value=2, type="integer")
                imdel(foutput, ver-)
	}else if(naxis1==256){ # MIRS & MIRL
		finput  = "../rawdata/"//fname//"_M.fits"

		# MIRS
		tmp1 = finput//"[1:256,1:256,*]"
		sname = fname//"_S"
 		imcopy (tmp1, sname, verbose=verb)
		foutput = sname
		hedit (foutput, "OBJECT", object_name, add=yes, addonly=no, delete=no, verify=no, show=no, update=yes)
		hedit (foutput, "DETECTOR", "MIRS", add=yes, addonly=no, delete=no, verify=no, show=no, update=yes)
		hedit (foutput, "PIPEVER", "v"//pipever, add=no, addonly=yes, delete=no, verify=no, show=no, update=yes)
		ccdhedit (foutput, paramete="GAIN", value=epadu_mirs, type="real")
#		ccdhedit (foutput, paramete="CPIX1", value=141.0, type="real")
#		ccdhedit (foutput, paramete="CPIX2", value=128.0, type="real")
		ccdhedit (foutput, paramete="CPIX1", value=150.0, type="real")
		ccdhedit (foutput, paramete="CPIX2", value=118.0, type="real")
		hedit (foutput, "RA-L"  , "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
		hedit (foutput, "DEC-L" , "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
		hedit (foutput, "PA-L"  , "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
		imslice(sname, foutput, 3, verbose=verb)
		ccdhedit (foutput//"001.fits", paramete="EXPID", value=1, type="integer")
		ccdhedit (foutput//"002.fits", paramete="EXPID", value=2, type="integer")
		ccdhedit (foutput//"003.fits", paramete="EXPID", value=3, type="integer")
		ccdhedit (foutput//"004.fits", paramete="EXPID", value=4, type="integer")
		imdel(sname, ver-)

		# MIRL
		tmp2 = finput//"[1:256,257:512,*]"
		lname = fname//"_L"
		imcopy (tmp2, lname, verbose=verb)
		foutput = lname
		hedit (foutput, "OBJECT", object_name, add=yes, addonly=no, delete=no, verify=no, show=no, update=yes)
		hedit (foutput, "DETECTOR", "MIRL", add=yes, addonly=no, delete=no, verify=no, show=no, update=yes)
		hedit (foutput, "PIPEVER", "v"//pipever, add=no, addonly=yes, delete=no, verify=no, show=no, update=yes)
		ccdhedit (foutput, paramete="GAIN", value=epadu_mirl, type="real")
		ccdhedit (foutput, paramete="CPIX1", value=121.0, type="real")
#		ccdhedit (foutput, paramete="CPIX2", value=128.0, type="real")
		ccdhedit (foutput, paramete="CPIX2", value=121.0, type="real")
		hedit (foutput, "RA-S"  , "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
		hedit (foutput, "DEC-S" , "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
		hedit (foutput, "PA-S"  , "", add=no, addonly=no, delete=yes, verify=no, show=no, update=yes)
		imslice(lname, foutput, 3, verbose=verb)
		ccdhedit (foutput//"001.fits", paramete="EXPID", value=1, type="integer")
		ccdhedit (foutput//"002.fits", paramete="EXPID", value=2, type="integer")
		ccdhedit (foutput//"003.fits", paramete="EXPID", value=3, type="integer")
		ccdhedit (foutput//"004.fits", paramete="EXPID", value=4, type="integer")
		imdel(lname, ver-)
	}
 }

# cleaning
 if( access("filename.list") ){ delete("filename.list", ver-) }
 if( access("slice_tmp0")    ){ delete("slice_tmp0", ver-)    }
 if( access("output.list")   ){ delete("output.list", ver-)   }

 print ("### IRCSLICE finished!! ###\n")

end

