# prepipeline.cl -- IRC imaging data reduction pre-pipeline task
# Created: Yoshifusa Ita, 01-Jul-05
# 02-Jul-05 - Add redbox.ircslice (Y. Ita)
# 14-Jul-05 - Add redbox.mkirclog (Y. Ita)
# 11-May-06 - Add lines to comment out dark and spectroscopic data (Y. Ita)

procedure prepipeline

string  ircconst     {"constants.database", prompt="IRC constants database file name"}
bool 	verbose = no {prompt="Print verbose progress messages?\n"}
string  mode="al"

begin
 string logfile, irc_const, pcommand
 bool verb

 print ("\n")
 print ("### PRE-PIPELINE ###\n")

# get query parameter
 irc_const = ircconst
 verb = verbose

# ircslice
 ircslice(irc_const, verb)

# make irclog
 mkirclog(irc_const, verb)

# comment out dark and spectroscopy data
# for gnu sed only
# ! cat irclog | sed -e '/ DARK \| NP \| NG \| SG1 \| SG2 \| LG1 \| LG2 \| UNDEF /s/^/#/' > tmp
# for all sed
 ! cat irclog | sed -e '/ DARK /s/^/#/' -e '/ NP /s/^/#/' -e '/ NG /s/^/#/' -e '/ SG1 /s/^/#/' -e '/ SG2 /s/^/#/' -e '/ LG1 /s/^/#/' -e '/ LG2 /s/^/#/' -e '/ UNDEF /s/^/#/' > tmp
 ! \mv tmp irclog

 print ("\n")
 print ("### PRE-PIPELINE finished!! ###\n")
 print ("\n\n")
 print ("######\n Please edit \"irclog\" before running pipeline! \n######")
 print ("\n\n")


# make dark list
 pcommand = osfn ("ircperl$")
 pcommand = pcommand//"darklist.pl"
 printf("! %s irclog\n",pcommand) | cl


# check if the irclog is correct
 pcommand = osfn ("ircperl$")
 pcommand = pcommand//"checkirclog.pl"
 printf("! %s\n",pcommand) | cl

end
