// boresight2irc.c
// ܥȤquotanian顢
// IRCNIR濴MIRS濴MIRL濴
// RA,DEC,Position angle׻륽ե
// Written by: Yoshifusa Ita
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "/usr/local/lib/atFunctions/2.6/include/atFunctions.h"
#include "/usr/local/lib/atFunctions/2.6/include/atError.h"
#undef DEG2RAD
#define DEG2RAD (M_PI/180.)
#undef RAD2DEG
#define RAD2DEG (180./M_PI)

int b2det(AtQuat , double , double , double *, double *, double *);

int main(int argc, char **argv){
  double offx, offy;
  double ra_b, dec_b, ra_n, dec_n, pa_n, ra_l, dec_l, pa_l;
  AtQuat qB;
  AtEulerAng eu;
    
  if(argc != 5 && argc != 1){
    printf("Usage: %s q1 q2 q3 q4 (boresight)\n",argv[0]);
    return(-1);
  }

  // ܥȤquotanian
  qB[0] = atof(argv[1]);
  qB[1] = atof(argv[2]);
  qB[2] = atof(argv[3]);
  qB[3] = atof(argv[4]);

  // ܥȤra,dec
  atQuatToEuler(qB, &eu);
  ra_b  = (eu.phi) * RAD2DEG;
  dec_b = (M_PI/2.0 - eu.theta) * RAD2DEG;

  // NIR濴boresightΥեå
  offx = -5.12; // X[arcmin]
  offy =  4.55 + 0.95; // Y[arcmin]
  b2det(qB, offx, offy, &ra_n, &dec_n, &pa_n);

  // MIRL濴boresightΥեå
  offx = -25.39; // X[arcmin]
  offy =   0.00; // Y[arcmin]
  b2det(qB, offx, offy, &ra_l, &dec_l, &pa_l);

  // ̤񤭽Ф
  printf("Boresight RA DEC: %f %f\n",ra_b, dec_b);
  printf("NIR       RA DEC: %f %f %f\n",ra_n, dec_n, pa_n+90.);
  printf("MIRS      RA DEC: %f %f %f\n",ra_n, dec_n, pa_n);
  printf("MIRL      RA DEC: %f %f %f\n",ra_l, dec_l, pa_l);

  return 0;
}

int b2det(AtQuat qB, double offx, double offy, double *ra, double *dec, double *pa){
  AtQuat qx, qy, qtmp, qdet;
  AtEulerAng eu;

  // arcmin -> rad
  offx /= 60.; offx *= DEG2RAD;
  offy /= 60.; offy *= DEG2RAD;
  
  // XYޤβžɽquotanian
  // Xޤe=(1,0,0)ǲ󤷤ȡ
  qx[0]= sin(offx/2.); // ex
  qx[1]= 0.0;          // ey
  qx[2]= 0.0;          // ez
  qx[3]= cos(offx/2.); //
  // ǤY'ޤe=(0,cos,-sin)˲
  qy[0]= 0.0;          
  qy[1]= cos(offx)*sin(offy/2.); 
  qy[2]=-sin(offx)*sin(offy/2.);
  qy[3]= cos(offy/2.); 

  atQuatProd(qB,  qx, qtmp); // x-rot
  atQuatProd(qtmp,qy, qdet); // y-rot

  // quotanian -> radec
  atQuatToEuler(qdet, &eu);
  *ra  = (eu.phi) * RAD2DEG;
  *dec = (M_PI/2.0 - eu.theta) * RAD2DEG;
  *pa  = (M_PI - eu.psi) * RAD2DEG;

  return 0;
}
