// mkpair.c
// To make pair for coadd
// Created: Yoshifusa Ita, 18-Oct-05
// gcc -Wall -O2 -o mkpair mkpair.c -lm (Linux)
// gcc -O2 -o mkpair mkpair.c -lm (Solaris)

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#define ID_RADIUS 150.0 // $B:GBg%G%#%6%j%s%0H>7B!A(B30sec$B$H$+(B.. [arcsec]

struct irc{
  char fname[256];
  char filter[256];
  double radeg;
  double dedeg;
  char line[512];
  int pair_flag;
};

int main(int argc, char **argv){
  FILE *fp;
  struct irc *data;
  int n_data;
  int i,j,k;
  char text[512];
  double rr;

  // $B;H$$$+$?(B
  if(argc!=2){
    puts("mkpair [number of data(int)]");
    puts("Example: mkpair 350");
    exit(1);
  }

  // $B%$%s%W%C%H%U%!%$%k$rFI$_9~$`(B
  if(!(fp=fopen("mkpair.input","r"))){
    puts("cannot read mkpair.input");
    exit(2);
  }

  // $B%G!<%?$N?t$K$h$C$F%a%b%j3d$jEv$F(B
  n_data = atoi(argv[1]);
  data = (struct irc *)malloc(sizeof(struct irc)*n_data);

  // $B%G!<%?$rFI$_9~$s$G9=B$BN$K3JG<(B
  i=0;
  while(fgets(text, sizeof(text), fp)!=NULL){
    if(text[0]!='#'){
      strcpy(data[i].line, text);
      sscanf(text,"%s %s %lf %lf",
	     data[i].fname,
	     data[i].filter,
	     &data[i].radeg,
	     &data[i].dedeg);
      data[i].pair_flag = 0;
      i++;
    }
  }
  n_data = i;
  fclose(fp);

  // $B%Z%"%j%s%03+;O(B
  k = 0;
  for(i=0;i<n_data;i++){
    if(data[i].pair_flag==0){
      k++;
      // $B%U%!%$%k$K=q$-9~$`0Y$N=`Hw(B
      sprintf(text,"pair%04d.list",k);
      if(!(fp=fopen(text,"w"))){
	printf("cannot write %s\n", text);
	exit(2);
      }
      for(j=0;j<n_data;j++){
	if(data[j].pair_flag==0){
	  rr = sqrt(pow((data[i].radeg-data[j].radeg),2)+
		    pow((data[i].dedeg-data[j].dedeg),2));
	  if(strcmp(data[i].filter,data[j].filter)==0){
	    fprintf(fp,"%s",data[j].line);
	    data[i].pair_flag = 1;
	    data[j].pair_flag = 1;
	  }
	}
      }
      fclose(fp);
      sprintf(text,"mv pair%04d.list pair%04d_%s.list",k,k,data[i].filter);
      system(text);
    }
  }

  return 0;
}
